<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FranquiaFormatoPermitido extends Model
{
    protected $table = 'franquia_formatos_permitidos';
    
    protected $fillable = [
        'franquia_id',
        'formato',
        'ativo',
    ];
    
    protected $casts = [
        'ativo' => 'boolean',
    ];
    
    public function franquia()
    {
        return $this->belongsTo(Empresa::class, 'franquia_id');
    }
}
