<?php

namespace App\Models;

use App\Traits\Userstamps;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Hotspot extends Model
{
    use HasFactory, SoftDeletes, Userstamps;

    protected $fillable = [
        'marca',
        'modelo',
        'serial',
        'franquia_id',
        'cliente_id',
        'situacao',
        'vpn_ip',
        'vpn_login',
        'vpn_password',
        'status',
        'last_activity_at'
    ];

    /**
     * The attributes that should be cast.
     */
    protected $casts = [
        'last_activity_at' => 'datetime',
        'status' => 'boolean',
    ];

    /**
     * Relacionamento com Franquia (empresa que gerencia o hotspot)
     */
    public function franquia()
    {
        return $this->belongsTo(Empresa::class, 'franquia_id');
    }

    /**
     * Relacionamento com Cliente (empresa onde o hotspot está instalado)
     */
    public function cliente()
    {
        return $this->belongsTo(Empresa::class, 'cliente_id');
    }

    /**
     * Relacionamento: Hotspot tem muitas impressões
     */
    public function impressoes(): HasMany
    {
        return $this->hasMany(PublicacaoImpressao::class);
    }

    /**
     * Relacionamento: Hotspot tem muitos cliques
     */
    public function cliques(): HasMany
    {
        return $this->hasMany(PublicacaoClique::class);
    }

    /**
     * Relacionamento legado (mantido para compatibilidade)
     * @deprecated Use franquia() ou cliente()
     */
    public function empresa()
    {
        return $this->cliente();
    }

    /**
     * Relacionamento com o usuário que criou
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Relacionamento com o usuário que atualizou
     */
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    /**
     * Relacionamento com o usuário que deletou
     */
    public function destroyer()
    {
        return $this->belongsTo(User::class, 'deleted_by');
    }
}
