<?php

namespace App\Models;

use App\Traits\Userstamps;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Midia extends Model
{
    use HasFactory, SoftDeletes, Userstamps;

    /**
     * Nome da tabela no banco de dados
     * Tabela foi renomeada de 'midias' para 'criativos' em 17/10/2025
     */
    protected $table = 'criativos';

    protected $fillable = [
        // Campos originais (alguns renomeados na migration)
        'title',
        'tipo',  // Renomeado de 'type'
        'path',
        'empresa_legado_id',  // Renomeado de 'empresa_id'
        'equipment_serial',
        'status',
        'views_count',
        'position',
        'start_datetime',
        'end_datetime',
        
        // Campos novos da tabela criativos
        'franquia_id',
        'formato',
        'conteudo_html',
        'status_aprovacao',
        'aprovado_por',
        'aprovado_em',
        'motivo_rejeicao',
        'bloqueado_permanente'
    ];

    /**
     * Relacionamento com Empresa (legado)
     * Campo renomeado de empresa_id para empresa_legado_id
     */
    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresa_legado_id');
    }

    /**
     * Relacionamento com Franquia (novo)
     * Franquia dona do criativo (null = catálogo FreeFi)
     */
    public function franquia()
    {
        return $this->belongsTo(Empresa::class, 'franquia_id');
    }

    /**
     * Usuário que aprovou o criativo
     */
    public function aprovador()
    {
        return $this->belongsTo(User::class, 'aprovado_por');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function destroyer()
    {
        return $this->belongsTo(User::class, 'deleted_by');
    }
}
