<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class EmpresaFactory extends Factory
{
    public function definition(): array
    {
        return [
            'name' => fake()->company,
            'email' => fake()->unique()->safeEmail,
            'phone' => fake()->phoneNumber,
            'codigo_convite' => $this->gerarCodigoConvite(),
        ];
    }

    /**
     * Gerar código de convite único
     * Formato: EGU2160261 (10 caracteres alfanuméricos)
     * 3 letras maiúsculas + 7 números
     */
    private function gerarCodigoConvite(): string
    {
        $letras = strtoupper(Str::random(3)); // ABC, XYZ, EGU
        $numeros = str_pad(rand(0, 9999999), 7, '0', STR_PAD_LEFT); // 2160261
        
        return $letras . $numeros; // EGU2160261
    }
}
