<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Empresa;

class MidiaFactory extends Factory
{
    public function definition(): array
    {
        $tipo = fake()->randomElement(['imagem', 'video']);
        $formato = $tipo === 'imagem' ? fake()->randomElement(['jpg', 'png', 'gif']) : 'mp4';

        return [
            'franquia_id' => Empresa::factory()->create(['tipo_empresa' => 'franquia'])->id,
            'tipo' => $tipo,
            'title' => fake()->sentence(3),
            'formato' => $formato,
            'path' => 'uploads/criativos/' . fake()->uuid() . '.' . $formato,
            'status_aprovacao' => 'aprovado',
            'status' => 1, // 1 = ativo (tinyint)
            'position' => fake()->numberBetween(1, 6),
            'start_datetime' => fake()->dateTimeBetween('-1 month', '+1 month'),
            'end_datetime' => fake()->dateTimeBetween('+1 month', '+2 months'),
            'views_count' => fake()->numberBetween(0, 1000),
        ];
    }
}
