<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class PermissionFactory extends Factory
{
    public function definition(): array
    {
        $subsystem = fake()->word;
        $action = fake()->word;
        return [
            'name' => ucfirst($action) . ' ' . ucfirst($subsystem),
            'description' => fake()->sentence,
            'subsystem' => $subsystem,
            'action' => $action,
            'slug' => $subsystem . '.' . $action,
        ];
    }
}
