<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\PublicacaoImpressao>
 */
class PublicacaoImpressaoFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'hotspot_id' => \App\Models\Hotspot::factory(),
            'publicacao_id' => \App\Models\Publicacao::factory(),
            'criativo_id' => \App\Models\Criativo::factory(),
            'data' => fake()->dateTimeBetween('-30 days', 'now')->format('Y-m-d'),
            'impressoes' => fake()->numberBetween(50, 5000),
            'usuarios_unicos' => fake()->numberBetween(10, 1000),
        ];
    }

    /**
     * Estado: Hoje
     */
    public function hoje(): static
    {
        return $this->state(fn (array $attributes) => [
            'data' => now()->format('Y-m-d'),
        ]);
    }

    /**
     * Estado: Ontem
     */
    public function ontem(): static
    {
        return $this->state(fn (array $attributes) => [
            'data' => now()->subDay()->format('Y-m-d'),
        ]);
    }

    /**
     * Estado: Alta performance
     */
    public function altaPerformance(): static
    {
        return $this->state(fn (array $attributes) => [
            'impressoes' => fake()->numberBetween(3000, 10000),
            'usuarios_unicos' => fake()->numberBetween(800, 3000),
        ]);
    }

    /**
     * Estado: Baixa performance
     */
    public function baixaPerformance(): static
    {
        return $this->state(fn (array $attributes) => [
            'impressoes' => fake()->numberBetween(10, 100),
            'usuarios_unicos' => fake()->numberBetween(5, 50),
        ]);
    }
}
