<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\WalledGarden>
 */
class WalledGardenFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $tipo = fake()->randomElement(['domain', 'ip', 'subnet']);
        
        $endereco = match($tipo) {
            'domain' => fake()->domainName(),
            'ip' => fake()->ipv4(),
            'subnet' => fake()->ipv4() . '/' . fake()->numberBetween(16, 30),
        };
        
        return [
            'publicacao_id' => \App\Models\Publicacao::factory(),
            'tipo' => $tipo,
            'endereco' => $endereco,
            'descricao' => fake()->optional()->sentence(),
            'ativo' => fake()->boolean(90), // 90% ativo
        ];
    }

    /**
     * Estado: Domain
     */
    public function domain(): static
    {
        return $this->state(fn (array $attributes) => [
            'tipo' => 'domain',
            'endereco' => fake()->domainName(),
        ]);
    }

    /**
     * Estado: IP
     */
    public function ip(): static
    {
        return $this->state(fn (array $attributes) => [
            'tipo' => 'ip',
            'endereco' => fake()->ipv4(),
        ]);
    }

    /**
     * Estado: Subnet
     */
    public function subnet(): static
    {
        return $this->state(fn (array $attributes) => [
            'tipo' => 'subnet',
            'endereco' => fake()->ipv4() . '/' . fake()->numberBetween(16, 30),
        ]);
    }

    /**
     * Estado: Inativo
     */
    public function inativo(): static
    {
        return $this->state(fn (array $attributes) => [
            'ativo' => false,
        ]);
    }
}
