<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('groups', function (Blueprint $table) {
      $table->id();
      $table->string('name');
      $table->string('description')->nullable();
      $table->timestamps();
    });
    Schema::create('permissions', function (Blueprint $table) {
      $table->id();
      $table->string('subsystem',100);
      $table->string('action',100);
      $table->string('name');
      $table->text('description')->nullable();
      $table->string('slug',150)->unique(); // subsystem.action
      $table->timestamps();
    });
    Schema::create('group_user', function (Blueprint $table) {
      $table->unsignedBigInteger('group_id');
      $table->unsignedBigInteger('user_id');
      $table->primary(['group_id','user_id']);
    });
    Schema::create('group_permission', function (Blueprint $table) {
      $table->unsignedBigInteger('group_id');
      $table->unsignedBigInteger('permission_id');
      $table->primary(['group_id','permission_id']);
    });
  }
  public function down(): void {
    Schema::dropIfExists('group_permission');
    Schema::dropIfExists('group_user');
    Schema::dropIfExists('permissions');
    Schema::dropIfExists('groups');
  }
};
