<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('midias', function (Blueprint $table) {
            $table->integer('position')->after('equipment_serial')->nullable();
            $table->dateTime('start_datetime')->after('position')->nullable();
            $table->dateTime('end_datetime')->after('start_datetime')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('midias', function (Blueprint $table) {
            $table->dropColumn('position');
            $table->dropColumn('start_datetime');
            $table->dropColumn('end_datetime');
        });
    }
};
