<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('hotspots', function (Blueprint $table) {
            // Franquia que gerencia o hotspot (nullable temporariamente)
            $table->foreignId('franquia_id')
                  ->nullable()
                  ->after('id')
                  ->constrained('empresas')
                  ->onDelete('restrict');
            
            // Situação logística do hotspot
            $table->enum('situacao', [
                      'estoque',
                      'em_transito',
                      'aguardando_instalacao',
                      'instalado',
                      'manutencao',
                      'desativado'
                  ])
                  ->default('instalado')
                  ->after('serial')
                  ->comment('Status logístico do equipamento');
            
            // Índices para performance
            $table->index('franquia_id');
            $table->index('situacao');
        });
        
        // Renomear empresa_id para cliente_id
        Schema::table('hotspots', function (Blueprint $table) {
            $table->renameColumn('empresa_id', 'cliente_id');
        });
        
        // Tornar cliente_id nullable
        Schema::table('hotspots', function (Blueprint $table) {
            $table->foreignId('cliente_id')
                  ->nullable()
                  ->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('hotspots', function (Blueprint $table) {
            $table->dropForeign(['franquia_id']);
            $table->dropIndex(['franquia_id']);
            $table->dropIndex(['situacao']);
            $table->dropColumn(['franquia_id', 'situacao']);
            
            // Reverter cliente_id para empresa_id
            $table->renameColumn('cliente_id', 'empresa_id');
            
            // Remover nullable
            $table->foreignId('empresa_id')
                  ->nullable(false)
                  ->change();
        });
    }
};
