<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('logs_acesso_wifi', function (Blueprint $table) {
            $table->id();
            
            // Hotspot onde ocorreu o acesso
            $table->foreignId('hotspot_id')
                  ->constrained('hotspots')
                  ->onDelete('cascade');
            
            // Franquia e Cliente (denormalizado para performance)
            $table->foreignId('franquia_id')
                  ->constrained('empresas')
                  ->onDelete('cascade');
            
            $table->foreignId('cliente_id')
                  ->nullable()
                  ->constrained('empresas')
                  ->onDelete('set null');
            
            // Dados do usuário (anonimizados por privacidade/LGPD)
            $table->string('mac_address_hash')->comment('Hash do MAC para privacidade');
            $table->string('ip_address', 45);
            $table->text('user_agent')->nullable();
            
            // Publicação visualizada (se houver)
            $table->foreignId('publicacao_visualizada_id')
                  ->nullable()
                  ->constrained('publicacoes')
                  ->onDelete('set null');
            
            // Tempo de sessão em segundos
            $table->integer('tempo_sessao')->default(0);
            
            // Tipo de dispositivo
            $table->enum('dispositivo_tipo', ['mobile', 'desktop', 'tablet', 'outro'])
                  ->default('outro');
            
            // Timestamp do acesso
            $table->timestamp('created_at')->useCurrent();
            
            // Índices para queries de relatórios
            $table->index('hotspot_id');
            $table->index('franquia_id');
            $table->index('cliente_id');
            $table->index('created_at');
            $table->index(['hotspot_id', 'created_at']);
            $table->index(['cliente_id', 'created_at']);
            $table->index('mac_address_hash');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('logs_acesso_wifi');
    }
};
