<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('criativos', function (Blueprint $table) {
            // Tornar empresa_legado_id nullable
            // (usado para compatibilidade com sistema antigo)
            $table->foreignId('empresa_legado_id')
                  ->nullable()
                  ->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('criativos', function (Blueprint $table) {
            // Reverter para NOT NULL
            $table->foreignId('empresa_legado_id')
                  ->nullable(false)
                  ->change();
        });
    }
};
