<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Apenas executar em MySQL
        if (DB::connection()->getDriverName() === 'mysql') {
            // Converter a tabela criativos para utf8mb4
            DB::statement('ALTER TABLE criativos CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
            
            // Garantir que colunas de texto estejam corretas
            DB::statement('ALTER TABLE criativos MODIFY title VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
            DB::statement('ALTER TABLE criativos MODIFY conteudo_html TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
            DB::statement('ALTER TABLE criativos MODIFY motivo_rejeicao TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
            
            // Também corrigir a tabela publicacoes
            DB::statement('ALTER TABLE publicacoes CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
            DB::statement('ALTER TABLE publicacoes MODIFY titulo VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
            
            // Corrigir a tabela empresas
            DB::statement('ALTER TABLE empresas CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
            DB::statement('ALTER TABLE empresas MODIFY name VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Não precisa reverter charset
    }
};
