<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('hotspots', function (Blueprint $table) {
            $table->string('vpn_ip', 50)->nullable()->after('situacao');
            $table->string('vpn_login', 100)->nullable()->after('vpn_ip');
            $table->string('vpn_password', 255)->nullable()->after('vpn_login');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('hotspots', function (Blueprint $table) {
            $table->dropColumn(['vpn_ip', 'vpn_login', 'vpn_password']);
        });
    }
};
