<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('publicacao_cliques', function (Blueprint $table) {
            $table->id();
            $table->foreignId('hotspot_id')->constrained('hotspots')->onDelete('cascade');
            $table->foreignId('publicacao_id')->constrained('publicacoes')->onDelete('cascade');
            $table->foreignId('criativo_id')->constrained('criativos')->onDelete('cascade');
            $table->string('ip_usuario', 45);
            $table->text('user_agent')->nullable();
            $table->timestamp('clicked_at');
            $table->timestamps();
            
            // Índices para queries de performance
            $table->index(['hotspot_id', 'publicacao_id', 'clicked_at']);
            $table->index(['publicacao_id', 'clicked_at']);
            $table->index('clicked_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('publicacao_cliques');
    }
};
