<?php

namespace Database\Seeders;

use App\Models\Empresa;
use App\Models\Hotspot;
use App\Models\User;
use Illuminate\Database\Seeder;

class HotspotComSituacoesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $superAdmin = User::where('email', 'admin@freefi.com.br')->first();
        
        // Buscar franquias e clientes
        $franquiaSP = Empresa::where('name', 'FreeFi São Paulo')->first();
        $franquiaRJ = Empresa::where('name', 'FreeFi Rio de Janeiro')->first();
        
        $clienteShopping = Empresa::where('name', 'Shopping Vila Olímpia')->first();
        $clienteRestaurante = Empresa::where('name', 'Restaurante Fogo de Chão')->first();
        $clienteBar = Empresa::where('name', 'Bar Urca Point')->first();
        
        $marcas = ['TP-Link', 'Ubiquiti', 'MikroTik', 'Cisco', 'D-Link'];
        $modelos = ['EAP225', 'UniFi AP', 'RB750', 'Aironet', 'DAP-2610'];
        
        echo "📡 CRIANDO HOTSPOTS...\n\n";
        
        // ==========================================
        // FRANQUIA SP - Hotspots
        // ==========================================
        echo "🏢 Franquia São Paulo:\n";
        
        // 1. Hotspot em ESTOQUE
        $h1 = Hotspot::create([
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => null, // Em estoque
            'marca' => $marcas[0],
            'modelo' => $modelos[0],
            'serial' => 'SPEST' . str_pad(rand(1, 9999), 4, '0', STR_PAD_LEFT),
            'situacao' => 'estoque',
            'status' => 0,
            'created_by' => $superAdmin->id,
        ]);
        echo "  📦 Estoque: {$h1->marca} {$h1->modelo} - {$h1->serial}\n";
        
        // 2. Hotspot EM TRÂNSITO para cliente
        $h2 = Hotspot::create([
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteShopping->id,
            'marca' => $marcas[1],
            'modelo' => $modelos[1],
            'serial' => 'SPTRA' . str_pad(rand(1, 9999), 4, '0', STR_PAD_LEFT),
            'situacao' => 'em_transito',
            'status' => 0,
            'created_by' => $superAdmin->id,
        ]);
        echo "  🚚 Em trânsito → {$clienteShopping->name}: {$h2->marca} {$h2->modelo}\n";
        
        // 3. Hotspot AGUARDANDO INSTALAÇÃO
        $h3 = Hotspot::create([
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteShopping->id,
            'marca' => $marcas[2],
            'modelo' => $modelos[2],
            'serial' => 'SPAGU' . str_pad(rand(1, 9999), 4, '0', STR_PAD_LEFT),
            'situacao' => 'aguardando_instalacao',
            'status' => 0,
            'last_activity_at' => null,
            'created_by' => $superAdmin->id,
        ]);
        echo "  ⏳ Aguardando instalação → {$clienteShopping->name}: {$h3->marca} {$h3->modelo}\n";
        
        // 4. Hotspot INSTALADO e ATIVO (< 1h)
        $h4 = Hotspot::create([
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteShopping->id,
            'marca' => $marcas[3],
            'modelo' => $modelos[3],
            'serial' => 'SPINST001',
            'situacao' => 'instalado',
            'status' => 0,
            'last_activity_at' => now()->subMinutes(30), // 30 min atrás
            'created_by' => $superAdmin->id,
        ]);
        echo "  ✅ Instalado (ativo < 1h) → {$clienteShopping->name}: {$h4->marca} {$h4->modelo} 🟢\n";
        
        // 5. Hotspot INSTALADO (ativo hoje)
        $h5 = Hotspot::create([
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteShopping->id,
            'marca' => $marcas[0],
            'modelo' => $modelos[0],
            'serial' => 'SPINST002',
            'situacao' => 'instalado',
            'status' => 0,
            'last_activity_at' => now()->subHours(12), // 12h atrás
            'created_by' => $superAdmin->id,
        ]);
        echo "  ✅ Instalado (ativo hoje) → {$clienteShopping->name}: {$h5->marca} {$h5->modelo} 🔵\n";
        
        // 6. Hotspot INSTALADO (atenção 48h)
        $h6 = Hotspot::create([
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteRestaurante->id,
            'marca' => $marcas[1],
            'modelo' => $modelos[1],
            'serial' => 'SPINST003',
            'situacao' => 'instalado',
            'status' => 0,
            'last_activity_at' => now()->subHours(48), // 48h atrás
            'created_by' => $superAdmin->id,
        ]);
        echo "  ⚠️  Instalado (atenção 48h) → {$clienteRestaurante->name}: {$h6->marca} {$h6->modelo} 🟠\n";
        
        // 7. Hotspot INSTALADO (offline > 72h)
        $h7 = Hotspot::create([
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteRestaurante->id,
            'marca' => $marcas[2],
            'modelo' => $modelos[2],
            'serial' => 'SPINST004',
            'situacao' => 'instalado',
            'status' => 0,
            'last_activity_at' => now()->subDays(5), // 5 dias atrás
            'created_by' => $superAdmin->id,
        ]);
        echo "  🔴 Instalado (offline > 72h) → {$clienteRestaurante->name}: {$h7->marca} {$h7->modelo} 🔴\n";
        
        // 8. Hotspot em MANUTENÇÃO
        $h8 = Hotspot::create([
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteShopping->id,
            'marca' => $marcas[3],
            'modelo' => $modelos[3],
            'serial' => 'SPMANU001',
            'situacao' => 'manutencao',
            'status' => 0,
            'last_activity_at' => now()->subDays(2),
            'created_by' => $superAdmin->id,
        ]);
        echo "  🔧 Manutenção → {$clienteShopping->name}: {$h8->marca} {$h8->modelo}\n";
        
        // 9. Hotspot DESATIVADO
        $h9 = Hotspot::create([
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteShopping->id,
            'marca' => $marcas[4],
            'modelo' => $modelos[4],
            'serial' => 'SPDES001',
            'situacao' => 'desativado',
            'status' => 1, // Status desativado
            'last_activity_at' => now()->subDays(30),
            'created_by' => $superAdmin->id,
        ]);
        echo "  ❌ Desativado → {$clienteShopping->name}: {$h9->marca} {$h9->modelo}\n";
        
        // ==========================================
        // FRANQUIA RJ - Hotspots
        // ==========================================
        echo "\n🏢 Franquia Rio de Janeiro:\n";
        
        // Hotspots em estoque (2)
        for ($i = 1; $i <= 2; $i++) {
            Hotspot::create([
                'franquia_id' => $franquiaRJ->id,
                'cliente_id' => null,
                'marca' => $marcas[rand(0, 4)],
                'modelo' => $modelos[rand(0, 4)],
                'serial' => 'RJEST' . str_pad($i, 4, '0', STR_PAD_LEFT),
                'situacao' => 'estoque',
                'status' => 0,
                'created_by' => $superAdmin->id,
            ]);
        }
        echo "  📦 2 hotspots em estoque\n";
        
        // Hotspot instalado no Bar Urca Point
        $h10 = Hotspot::create([
            'franquia_id' => $franquiaRJ->id,
            'cliente_id' => $clienteBar->id,
            'marca' => $marcas[0],
            'modelo' => $modelos[0],
            'serial' => 'RJINST001',
            'situacao' => 'instalado',
            'status' => 0,
            'last_activity_at' => now()->subHours(2),
            'created_by' => $superAdmin->id,
        ]);
        echo "  ✅ Instalado (ativo hoje) → {$clienteBar->name}: {$h10->marca} {$h10->modelo} 🔵\n";
        
        echo "\n";
        echo "📊 RESUMO DE HOTSPOTS:\n";
        echo "   • Estoque: " . Hotspot::where('situacao', 'estoque')->count() . "\n";
        echo "   • Em trânsito: " . Hotspot::where('situacao', 'em_transito')->count() . "\n";
        echo "   • Aguardando instalação: " . Hotspot::where('situacao', 'aguardando_instalacao')->count() . "\n";
        echo "   • Instalados: " . Hotspot::where('situacao', 'instalado')->count() . "\n";
        echo "   • Manutenção: " . Hotspot::where('situacao', 'manutencao')->count() . "\n";
        echo "   • Desativados: " . Hotspot::where('situacao', 'desativado')->count() . "\n";
        echo "   • Total: " . Hotspot::count() . " hotspots\n";
        echo "\n";
        echo "📊 STATUS DE ATIVIDADE:\n";
        echo "   • 🟢 Ativo (< 1h): " . Hotspot::whereNotNull('last_activity_at')->where('last_activity_at', '>=', now()->subHour())->count() . "\n";
        echo "   • 🔵 Ativo hoje (< 24h): " . Hotspot::whereNotNull('last_activity_at')->whereBetween('last_activity_at', [now()->subDay(), now()->subHour()])->count() . "\n";
        echo "   • 🟠 Atenção (24-72h): " . Hotspot::whereNotNull('last_activity_at')->whereBetween('last_activity_at', [now()->subDays(3), now()->subDay()])->count() . "\n";
        echo "   • 🔴 Offline (> 72h): " . Hotspot::whereNotNull('last_activity_at')->where('last_activity_at', '<', now()->subDays(3))->count() . "\n";
        echo "   • ⚪ Sem registro: " . Hotspot::whereNull('last_activity_at')->count() . "\n";
    }
}
