<?php

namespace Database\Seeders;

use App\Models\Empresa;
use App\Models\User;
use Illuminate\Database\Seeder;

class UserComAprovacoesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $superAdmin = User::where('email', 'admin@freefi.com.br')->first();
        
        // Buscar franquias
        $franquiaSP = Empresa::where('name', 'FreeFi São Paulo')->first();
        $franquiaRJ = Empresa::where('name', 'FreeFi Rio de Janeiro')->first();
        $franquiaMG = Empresa::where('name', 'FreeFi Minas Gerais')->first();
        
        // Buscar clientes
        $clienteShopping = Empresa::where('name', 'Shopping Vila Olímpia')->first();
        $clienteRestaurante = Empresa::where('name', 'Restaurante Fogo de Chão')->first();
        
        echo "👥 CRIANDO USUÁRIOS...\n\n";
        
        // ==========================================
        // FRANQUIA SÃO PAULO - Usuários
        // ==========================================
        echo "🏢 Franquia São Paulo:\n";
        
        // Admin da Franquia SP (aprovado)
        $adminSP = User::create([
            'name' => 'João Silva',
            'email' => 'joao@freefissaop.com.br',
            'password' => bcrypt('password'),
            'empresa_id' => $franquiaSP->id,
            'status_cadastro' => 'aprovado',
            'aprovado_por' => $superAdmin->id,
            'aprovado_em' => now()->subDays(10),
            'created_by' => $superAdmin->id,
        ]);
        echo "  ✅ Admin aprovado: {$adminSP->name} ({$adminSP->email})\n";
        
        // Colaborador SP (aprovado)
        $colab1SP = User::create([
            'name' => 'Maria Santos',
            'email' => 'maria@freefisp.com.br',
            'password' => bcrypt('password'),
            'empresa_id' => $franquiaSP->id,
            'status_cadastro' => 'aprovado',
            'aprovado_por' => $adminSP->id,
            'aprovado_em' => now()->subDays(5),
            'created_by' => $adminSP->id,
        ]);
        echo "  ✅ Colaborador aprovado: {$colab1SP->name} ({$colab1SP->email})\n";
        
        // Colaborador SP (pendente de aprovação)
        $pendenteSP = User::create([
            'name' => 'Pedro Oliveira',
            'email' => 'pedro@freefisp.com.br',
            'password' => bcrypt('password'),
            'empresa_id' => $franquiaSP->id,
            'status_cadastro' => 'pendente',
            'created_by' => null,
        ]);
        echo "  ⏳ Pendente: {$pendenteSP->name} ({$pendenteSP->email})\n";
        
        // Colaborador SP (rejeitado)
        $rejeitadoSP = User::create([
            'name' => 'Carlos Souza',
            'email' => 'carlos@freefisp.com.br',
            'password' => bcrypt('password'),
            'empresa_id' => $franquiaSP->id,
            'status_cadastro' => 'rejeitado',
            'aprovado_por' => $adminSP->id,
            'aprovado_em' => now()->subDays(2),
            'motivo_rejeicao' => 'Documentação incompleta. Faltando comprovante de residência.',
            'created_by' => null,
        ]);
        echo "  ❌ Rejeitado: {$rejeitadoSP->name} - Motivo: {$rejeitadoSP->motivo_rejeicao}\n";
        
        // ==========================================
        // FRANQUIA RIO DE JANEIRO - Usuários
        // ==========================================
        echo "\n🏢 Franquia Rio de Janeiro:\n";
        
        // Admin da Franquia RJ (aprovado)
        $adminRJ = User::create([
            'name' => 'Ana Costa',
            'email' => 'ana@freefirj.com.br',
            'password' => bcrypt('password'),
            'empresa_id' => $franquiaRJ->id,
            'status_cadastro' => 'aprovado',
            'aprovado_por' => $superAdmin->id,
            'aprovado_em' => now()->subDays(15),
            'created_by' => $superAdmin->id,
        ]);
        echo "  ✅ Admin aprovado: {$adminRJ->name} ({$adminRJ->email})\n";
        
        // Colaborador RJ (pendente)
        $pendenteRJ = User::create([
            'name' => 'Lucas Ferreira',
            'email' => 'lucas@freefirj.com.br',
            'password' => bcrypt('password'),
            'empresa_id' => $franquiaRJ->id,
            'status_cadastro' => 'pendente',
            'created_by' => null,
        ]);
        echo "  ⏳ Pendente: {$pendenteRJ->name} ({$pendenteRJ->email})\n";
        
        // ==========================================
        // FRANQUIA MINAS GERAIS - Usuários
        // ==========================================
        echo "\n🏢 Franquia Minas Gerais:\n";
        
        // Admin da Franquia MG (aprovado)
        $adminMG = User::create([
            'name' => 'Roberto Alves',
            'email' => 'roberto@freefimg.com.br',
            'password' => bcrypt('password'),
            'empresa_id' => $franquiaMG->id,
            'status_cadastro' => 'aprovado',
            'aprovado_por' => $superAdmin->id,
            'aprovado_em' => now()->subDays(20),
            'created_by' => $superAdmin->id,
        ]);
        echo "  ✅ Admin aprovado: {$adminMG->name} ({$adminMG->email})\n";
        
        // ==========================================
        // CLIENTES - Usuários
        // ==========================================
        echo "\n👤 Usuários de Clientes:\n";
        
        // Cliente: Shopping Vila Olímpia
        $userShopping = User::create([
            'name' => 'Gerente Shopping',
            'email' => 'gerente@shoppingvilaolimpia.com.br',
            'password' => bcrypt('password'),
            'empresa_id' => $clienteShopping->id,
            'status_cadastro' => 'aprovado',
            'aprovado_por' => $adminSP->id,
            'aprovado_em' => now()->subDays(7),
            'created_by' => $adminSP->id,
        ]);
        echo "  ✅ Cliente (Shopping): {$userShopping->name} ({$userShopping->email})\n";
        
        // Cliente: Restaurante Fogo de Chão
        $userRestaurante = User::create([
            'name' => 'Dono Restaurante',
            'email' => 'dono@fogodechao.com.br',
            'password' => bcrypt('password'),
            'empresa_id' => $clienteRestaurante->id,
            'status_cadastro' => 'aprovado',
            'aprovado_por' => $adminSP->id,
            'aprovado_em' => now()->subDays(3),
            'created_by' => $adminSP->id,
        ]);
        echo "  ✅ Cliente (Restaurante): {$userRestaurante->name} ({$userRestaurante->email})\n";
        
        echo "\n";
        echo "📊 RESUMO DE USUÁRIOS:\n";
        echo "   • SuperAdmin: 1\n";
        echo "   • Admins de Franquia: 3 (SP, RJ, MG)\n";
        echo "   • Colaboradores Franquia: 1 (SP)\n";
        echo "   • Usuários Clientes: 2\n";
        echo "   • Pendentes: 2 (SP, RJ)\n";
        echo "   • Rejeitados: 1 (SP)\n";
        echo "   • Total: " . User::count() . " usuários\n";
        echo "\n";
        echo "🔑 LOGINS DE TESTE:\n";
        echo "   • SuperAdmin: admin@freefi.com.br / password\n";
        echo "   • Franquia SP: joao@freefissaop.com.br / password\n";
        echo "   • Franquia RJ: ana@freefirj.com.br / password\n";
        echo "   • Franquia MG: roberto@freefimg.com.br / password\n";
        echo "   • Cliente Shopping: gerente@shoppingvilaolimpia.com.br / password\n";
        echo "   • Cliente Restaurante: dono@fogodechao.com.br / password\n";
    }
}
