#!/bin/bash

###############################################################################
# Script: Executar TODOS os Testes do Módulo de Publicações
# Descrição: Executa testes unitários, funcionais, integração, E2E e Dusk
# Autor: Equipe FreeFi
# Data: 03/11/2025
###############################################################################

# Cores para output
GREEN='\033[0;32m'
BLUE='\033[0;34m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m' # No Color

# Diretório base do projeto
PROJECT_DIR="/var/www/html/laravel/admin/freefi_admin"
cd "$PROJECT_DIR" || exit 1

echo -e "${BLUE}╔════════════════════════════════════════════════════════════╗${NC}"
echo -e "${BLUE}║      Executando TODOS os Testes - Módulo Publicações      ║${NC}"
echo -e "${BLUE}╚════════════════════════════════════════════════════════════╝${NC}"
echo ""

# Variáveis de contadores
TOTAL_TESTS=0
PASSED_TESTS=0
FAILED_TESTS=0
START_TIME=$(date +%s)

###############################################################################
# FASE 1: Preparação
###############################################################################

echo -e "${YELLOW}[1/6] Preparando ambiente de testes...${NC}"
echo ""

# Limpar caches
php artisan config:clear --quiet
php artisan cache:clear --quiet
php artisan view:clear --quiet

# Preparar banco de teste
touch database/database.sqlite 2>/dev/null
php artisan migrate:fresh --env=testing --quiet --force

echo -e "${GREEN}✓ Ambiente preparado${NC}"
echo ""

###############################################################################
# FASE 2: Testes Unitários
###############################################################################

echo -e "${YELLOW}[2/6] Executando Testes Unitários...${NC}"
echo ""

php artisan test tests/Unit/Publicacao --stop-on-failure
UNIT_RESULT=$?

if [ $UNIT_RESULT -eq 0 ]; then
    echo -e "${GREEN}✓ Testes Unitários: PASSARAM${NC}"
    PASSED_TESTS=$((PASSED_TESTS + 1))
else
    echo -e "${RED}✗ Testes Unitários: FALHARAM${NC}"
    FAILED_TESTS=$((FAILED_TESTS + 1))
fi

TOTAL_TESTS=$((TOTAL_TESTS + 1))
echo ""

###############################################################################
# FASE 3: Testes Funcionais (Feature)
###############################################################################

echo -e "${YELLOW}[3/6] Executando Testes Funcionais...${NC}"
echo ""

php artisan test tests/Feature/Publicacao --stop-on-failure
FEATURE_RESULT=$?

if [ $FEATURE_RESULT -eq 0 ]; then
    echo -e "${GREEN}✓ Testes Funcionais: PASSARAM${NC}"
    PASSED_TESTS=$((PASSED_TESTS + 1))
else
    echo -e "${RED}✗ Testes Funcionais: FALHARAM${NC}"
    FAILED_TESTS=$((FAILED_TESTS + 1))
fi

TOTAL_TESTS=$((TOTAL_TESTS + 1))
echo ""

###############################################################################
# FASE 4: Testes de Integração
###############################################################################

echo -e "${YELLOW}[4/6] Executando Testes de Integração...${NC}"
echo ""

if [ -d "tests/Integration/Publicacao" ]; then
    php artisan test tests/Integration/Publicacao --stop-on-failure
    INTEGRATION_RESULT=$?
    
    if [ $INTEGRATION_RESULT -eq 0 ]; then
        echo -e "${GREEN}✓ Testes de Integração: PASSARAM${NC}"
        PASSED_TESTS=$((PASSED_TESTS + 1))
    else
        echo -e "${RED}✗ Testes de Integração: FALHARAM${NC}"
        FAILED_TESTS=$((FAILED_TESTS + 1))
    fi
    
    TOTAL_TESTS=$((TOTAL_TESTS + 1))
else
    echo -e "${YELLOW}⊘ Testes de Integração não encontrados (pulando)${NC}"
fi

echo ""

###############################################################################
# FASE 5: Testes E2E
###############################################################################

echo -e "${YELLOW}[5/6] Executando Testes E2E...${NC}"
echo ""

if [ -d "tests/E2E/Publicacao" ]; then
    php artisan test tests/E2E/Publicacao --stop-on-failure
    E2E_RESULT=$?
    
    if [ $E2E_RESULT -eq 0 ]; then
        echo -e "${GREEN}✓ Testes E2E: PASSARAM${NC}"
        PASSED_TESTS=$((PASSED_TESTS + 1))
    else
        echo -e "${RED}✗ Testes E2E: FALHARAM${NC}"
        FAILED_TESTS=$((FAILED_TESTS + 1))
    fi
    
    TOTAL_TESTS=$((TOTAL_TESTS + 1))
else
    echo -e "${YELLOW}⊘ Testes E2E não encontrados (pulando)${NC}"
fi

echo ""

###############################################################################
# FASE 6: Testes Dusk (Browser)
###############################################################################

echo -e "${YELLOW}[6/6] Executando Testes Dusk (Browser)...${NC}"
echo ""

# Verificar se ChromeDriver está instalado
if ! command -v chromedriver &> /dev/null; then
    echo -e "${YELLOW}ChromeDriver não encontrado. Instalando...${NC}"
    php artisan dusk:chrome-driver --detect
fi

php artisan dusk tests/Browser/Publicacao --stop-on-failure
DUSK_RESULT=$?

if [ $DUSK_RESULT -eq 0 ]; then
    echo -e "${GREEN}✓ Testes Dusk: PASSARAM${NC}"
    PASSED_TESTS=$((PASSED_TESTS + 1))
else
    echo -e "${RED}✗ Testes Dusk: FALHARAM${NC}"
    FAILED_TESTS=$((FAILED_TESTS + 1))
fi

TOTAL_TESTS=$((TOTAL_TESTS + 1))
echo ""

###############################################################################
# RESUMO FINAL
###############################################################################

END_TIME=$(date +%s)
DURATION=$((END_TIME - START_TIME))

echo ""
echo -e "${BLUE}╔════════════════════════════════════════════════════════════╗${NC}"
echo -e "${BLUE}║                     RESUMO DOS TESTES                      ║${NC}"
echo -e "${BLUE}╚════════════════════════════════════════════════════════════╝${NC}"
echo ""
echo -e "  Total de Suites:     ${TOTAL_TESTS}"
echo -e "  ${GREEN}✓ Passaram:          ${PASSED_TESTS}${NC}"
echo -e "  ${RED}✗ Falharam:          ${FAILED_TESTS}${NC}"
echo -e "  Duração:             ${DURATION}s"
echo ""

if [ $FAILED_TESTS -eq 0 ]; then
    echo -e "${GREEN}╔════════════════════════════════════════════════════════════╗${NC}"
    echo -e "${GREEN}║          ✓ TODOS OS TESTES PASSARAM COM SUCESSO!          ║${NC}"
    echo -e "${GREEN}╚════════════════════════════════════════════════════════════╝${NC}"
    exit 0
else
    echo -e "${RED}╔════════════════════════════════════════════════════════════╗${NC}"
    echo -e "${RED}║        ✗ ALGUNS TESTES FALHARAM - REVISAR LOGS!           ║${NC}"
    echo -e "${RED}╚════════════════════════════════════════════════════════════╝${NC}"
    exit 1
fi
