# 🚀 Guia Rápido - Deploy para MikroTik

## ✅ Pré-requisitos

- [x] VPN conectada
- [x] MikroTik acessível em `1.2.0.237`
- [x] Senha: `Delta46.capiba2!`

---

## 🎯 Como Fazer Deploy

### **Método 1: Script Simples (Recomendado)**

```bash
# 1. Conectar na VPN
# 2. Navegar até o diretório do projeto
cd /var/www/html/laravel/admin/freefi_admin

# 3. Executar o deploy
bash deploy-mikrotik-simple.sh
```

**O script vai:**
1. ✅ Verificar conexão com MikroTik
2. ✅ Mostrar arquivos que serão enviados
3. ✅ Pedir confirmação
4. ✅ Criar backup no MikroTik
5. ✅ Transferir arquivos via rsync/scp
6. ✅ Verificar se o deploy foi bem-sucedido

**Senha será solicitada 3 vezes:**
- 1x para criar backup
- 1x para transferir arquivos
- 1x para verificação

---

## 📋 Checklist Pós-Deploy

Após o deploy, testar:

### 1. **Conectar no WiFi do MikroTik**
- Conecte em uma rede gerenciada pelo hotspot

### 2. **Verificar Hotspot**
- Deve abrir a página de login automaticamente
- Verificar se o layout carrega corretamente

### 3. **Testar Publicidade**
- Verificar se o modal de publicidade abre
- Conferir se a imagem carrega do novo caminho:
  ```
  http://172.233.21.57:8082/storage/midias/...
  ```

### 4. **Verificar Auditoria**
No servidor Laravel:
```bash
ssh root@172.233.21.57 "cd /var/www/freefi && docker compose exec -T app php artisan tinker --execute='echo DB::table(\"auditoria_splash\")->count();'"
```

---

## 🔄 Estrutura de Deploy

```
LOCAL (seu PC)                    VPN                    MIKROTIK (1.2.0.237)
┌─────────────────┐              ┌───┐                 ┌──────────────────┐
│ flash/hotspot/  │─────rsync───>│VPN│────────────────>│ /flash/hotspot/  │
│  - index.html   │              └───┘                 │  - index.html    │
│  - cadastro.html│                                    │  - cadastro.html │
│  - css/         │                                    │  - css/          │
│  - js/          │                                    │  - js/           │
│  - img/         │                                    │  - img/          │
└─────────────────┘                                    └──────────────────┘
```

---

## 📝 Arquivos do Sistema de Deploy

| Arquivo | Descrição |
|---------|-----------|
| `deploy-mikrotik-simple.sh` | ✅ **Script principal** (usar este) |
| `deploy-mikrotik-configured.sh` | Versão com sshpass (requer instalação) |
| `deploy-mikrotik.sh` | Versão genérica (precisa configurar) |
| `.env.deploy` | Arquivo de configuração (opcional) |
| `DEPLOY-MIKROTIK-GUIDE.md` | Documentação completa |
| `DEPLOY-QUICKSTART.md` | Este guia rápido |

---

## 🆘 Troubleshooting Rápido

### Problema: "Conexão recusada"
```bash
# Verificar VPN
ping 1.2.0.237

# Testar SSH
ssh admin@1.2.0.237
```

### Problema: "Arquivos não atualizam"
```bash
# Limpar cache do MikroTik
ssh admin@1.2.0.237 "/ip hotspot walled-garden flush"

# Verificar arquivos
ssh admin@1.2.0.237 "ls -lh /flash/hotspot/"
```

### Problema: "Imagens não carregam"
- Verificar se o caminho está correto:
  - ❌ Antigo: `http://172.233.21.57/adm/anexos/`
  - ✅ Novo: `http://172.233.21.57:8082/storage/`

---

## 🔙 Rollback (Reverter Deploy)

Se algo der errado:

```bash
# 1. Conectar no MikroTik
ssh admin@1.2.0.237

# 2. Listar backups
ls -lh /flash/hotspot_backup_*

# 3. Restaurar backup
BACKUP="hotspot_backup_20251021_181344.tar.gz"
tar -xzf /flash/$BACKUP -C /flash
```

---

## 📞 Informações Importantes

**MikroTik (via VPN):**
- IP: `1.2.0.237`
- Usuário: `admin`
- Senha: `Delta46.capiba2!`
- Diretório: `/flash/hotspot/`

**Servidor Laravel:**
- IP: `172.233.21.57`
- Porta Admin: `8082`
- Porta Storage: `8082/storage/`
- Porta Splash: `80/splash/`

---

## ✅ Última Atualização Feita

**O que foi alterado no frontend:**
- `flash/hotspot/index.html` (linha 165)
- Caminho das imagens: `/adm/anexos/` → `/storage/`

**APIs modernizadas:**
- ✅ `splash_api.php` - Conecta no banco Laravel
- ✅ `audit_splash.php` - Grava em tabela Laravel

---

**Data:** 21/10/2025
**Versão:** 1.0
**Status:** ✅ Pronto para deploy
