# 🤖 Instruções para Deploy Automatizado - MikroTik Hotspot

Este documento contém todas as instruções necessárias para um agente de IA realizar o deploy automatizado dos arquivos do hotspot para o equipamento MikroTik.

---

## 📋 Contexto

Esta pasta contém:
- **Frontend do hotspot** (`hotspot/`) - Arquivos HTML/CSS/JS que rodam no MikroTik
- **Scripts de deploy** (`deploy/`) - Automação para transferir arquivos
- **Documentação completa** - Guias e logs de alterações

---

## 🎯 Objetivo do Deploy

Transferir os arquivos da pasta `hotspot/` para o equipamento MikroTik RouterOS via SSH/SCP, garantindo que:
1. Backup automático seja criado antes da transferência
2. Arquivos sejam transferidos com sucesso
3. Validação pós-deploy seja executada
4. Rollback seja possível em caso de problemas

---

## 🔐 Credenciais e Acesso

### **Equipamento MikroTik (Destino)**
```
IP: 1.2.0.237
Usuário: admin
Senha: Delta46.capiba2!
Porta SSH: 22 (padrão)
Destino: /flash/hotspot/
```

### **Acesso VPN**
⚠️ **IMPORTANTE:** O IP `1.2.0.237` só é acessível através de VPN.

**Teste de conectividade:**
```bash
ping -c 3 1.2.0.237
```

Se o ping falhar, a VPN não está conectada e o deploy falhará.

---

## 📂 Estrutura de Arquivos

### **Origem (nesta pasta):**
```
flash/
├── hotspot/              # ← ESTES arquivos devem ser enviados
│   ├── index.html
│   ├── cadastro.html
│   ├── login.html
│   ├── css/
│   ├── js/
│   ├── img/
│   └── ...
└── deploy/              # Scripts de automação
    ├── deploy-mikrotik-simple.sh       # Script principal
    ├── deploy-mikrotik-configured.sh   # Alternativa com sshpass
    └── deploy-mikrotik.sh             # Versão genérica
```

### **Destino (no MikroTik):**
```
/flash/hotspot/          # Raiz do hotspot no MikroTik
├── index.html
├── cadastro.html
├── login.html
├── css/
├── js/
├── img/
└── ...
```

---

## 🚀 Métodos de Deploy

### **Método 1: Script Automatizado (Recomendado)**

O script `deploy-mikrotik-simple.sh` já está pronto e faz tudo automaticamente:

```bash
cd flash/deploy
bash deploy-mikrotik-simple.sh
```

**O que o script faz:**
1. Verifica conectividade com o MikroTik
2. Lista arquivos que serão enviados
3. Solicita confirmação do usuário
4. Cria backup no MikroTik (formato: `hotspot_backup_YYYYMMDD_HHMMSS.tar.gz`)
5. Transfere arquivos via `rsync` (ou `scp` como fallback)
6. Valida que `index.html` foi atualizado corretamente
7. Lista arquivos no destino para verificação

**Senha será solicitada 2-3 vezes durante o processo.**

---

### **Método 2: Comandos Manuais**

Se preferir fazer manualmente ou adaptar para outro sistema:

#### **1. Criar Backup no MikroTik**
```bash
ssh admin@1.2.0.237 << 'EOF'
    BACKUP_NAME="hotspot_backup_$(date +%Y%m%d_%H%M%S)"
    if [ -d "/flash/hotspot" ]; then
        tar -czf "/flash/${BACKUP_NAME}.tar.gz" -C /flash hotspot
        echo "✓ Backup criado: /flash/${BACKUP_NAME}.tar.gz"
    fi
EOF
```

#### **2. Transferir Arquivos**

**Opção A: Com rsync (recomendado)**
```bash
rsync -avz --progress \
    --exclude="*.md" \
    --exclude="*.backup" \
    --exclude=".git" \
    --exclude="_errors.txt" \
    --exclude="*.log" \
    -e "ssh -o StrictHostKeyChecking=no" \
    hotspot/ admin@1.2.0.237:/flash/hotspot/
```

**Opção B: Com scp**
```bash
scp -r -o StrictHostKeyChecking=no \
    hotspot/* admin@1.2.0.237:/flash/hotspot/
```

#### **3. Validar Deploy**
```bash
ssh admin@1.2.0.237 << 'EOF'
    if [ -f "/flash/hotspot/index.html" ]; then
        if grep -q "8082/storage" "/flash/hotspot/index.html"; then
            echo "✓ Arquivo index.html atualizado corretamente!"
        else
            echo "⚠ Arquivo transferido mas pode estar com código antigo"
        fi
    else
        echo "✗ Arquivo index.html não encontrado!"
    fi

    echo ""
    echo "Arquivos no MikroTik:"
    ls -lh /flash/hotspot/*.html 2>/dev/null | awk '{print "  ", $9, "-", $5}'
EOF
```

---

## ✅ Checklist de Validação Pós-Deploy

Após o deploy, verificar:

### **No MikroTik (via SSH):**
```bash
ssh admin@1.2.0.237

# Listar arquivos transferidos
ls -lh /flash/hotspot/

# Verificar se backup foi criado
ls -lh /flash/hotspot_backup_*.tar.gz

# Validar conteúdo do index.html
grep "8082/storage" /flash/hotspot/index.html
```

### **No Navegador (usuário final):**
1. Conectar no WiFi do MikroTik
2. Abrir navegador (será redirecionado para página de login)
3. Verificar se modal de publicidade aparece
4. Confirmar que imagens carregam corretamente
5. Testar login/cadastro

### **Validação Crítica:**
O arquivo `index.html` deve conter na **linha 165**:
```javascript
var imageUrl = "http://172.233.21.57:8082/storage/" + response.imagem;
```

**NÃO pode estar:**
```javascript
var imageUrl = "http://172.233.21.57/adm/anexos/" + response.imagem;  // ❌ ANTIGO
```

---

## 🔄 Rollback (Reverter Deploy)

Se algo der errado, você pode restaurar o backup:

```bash
ssh admin@1.2.0.237

# Listar backups disponíveis
ls -lh /flash/hotspot_backup_*.tar.gz

# Restaurar backup específico (substitua a data)
tar -xzf /flash/hotspot_backup_20251021_150000.tar.gz -C /flash

# Verificar restauração
ls -lh /flash/hotspot/
```

---

## 🐛 Troubleshooting

### **Problema: "Connection refused" ou "No route to host"**
**Solução:** VPN não está conectada.
```bash
# Verificar conectividade
ping 1.2.0.237

# Se falhar, conectar na VPN primeiro
```

---

### **Problema: "Permission denied (publickey)"**
**Solução:** Autenticação por senha pode estar desabilitada.
```bash
# Forçar autenticação por senha
ssh -o PreferredAuthentications=password admin@1.2.0.237
```

---

### **Problema: rsync não encontrado**
**Solução:** Usar scp como alternativa.
```bash
scp -r hotspot/* admin@1.2.0.237:/flash/hotspot/
```

---

### **Problema: Imagens não carregam no hotspot**
**Causa:** Caminho antigo ainda está no código.

**Solução:** Verificar linha 165 do `index.html`:
```bash
grep -n "imageUrl" hotspot/index.html
```

Deve mostrar: `http://172.233.21.57:8082/storage/`

---

### **Problema: "Directory not found" no MikroTik**
**Solução:** Criar diretório manualmente:
```bash
ssh admin@1.2.0.237 "mkdir -p /flash/hotspot"
```

---

## 📊 Arquivos Críticos

### **Alterações Feitas nesta Modernização:**

**1. index.html (linha 165)**
- Atualizado caminho de imagens para novo storage Laravel
- Integração com API splash modernizada

**2. APIs Backend (não estão nesta pasta)**
- `/var/www/html/splash/splash_api.php` - Busca publicações
- `/var/www/html/splash/audit_splash.php` - Registra auditoria
- Ambas já foram modernizadas para PHP 8.3 + MySQL 8.0

**3. Frontend (hotspot/)**
- Apenas 1 linha alterada (index.html:165)
- Resto permanece igual

---

## 🔗 Integração com Backend

Após deploy no MikroTik, o hotspot fará chamadas para:

**API de Publicidade:**
```
http://172.233.21.57/splash/splash_api.php
```

**API de Auditoria:**
```
http://172.233.21.57/splash/audit_splash.php
```

**Storage de Imagens:**
```
http://172.233.21.57:8082/storage/[nome-do-arquivo]
```

---

## 📚 Documentação Adicional

- `README.md` - Visão geral completa do projeto
- `DEPLOY-QUICKSTART.md` - Guia rápido de deploy
- `DEPLOY-MIKROTIK-GUIDE.md` - Guia detalhado com exemplos
- `ATUALIZACOES-NECESSARIAS.md` - Log técnico de alterações
- `RESUMO-ATUALIZACAO.md` - Resumo executivo

---

## 🤖 Instruções para IA

Se você é uma IA executando este deploy:

1. **Verificar pré-requisitos:**
   - Conectividade com `1.2.0.237`
   - Acesso SSH funcionando
   - Ferramentas disponíveis: `ssh`, `rsync` ou `scp`

2. **Executar deploy:**
   - Usar script `deploy-mikrotik-simple.sh` OU
   - Seguir comandos manuais na seção "Método 2"

3. **Validar resultado:**
   - Executar checklist de validação
   - Verificar linha 165 do index.html no destino
   - Confirmar que backup foi criado

4. **Reportar:**
   - Status do deploy (sucesso/falha)
   - Arquivos transferidos (quantidade)
   - Nome do backup criado
   - Resultado da validação

---

## 📞 Suporte

**Em caso de dúvidas:**
- Consultar `DEPLOY-MIKROTIK-GUIDE.md` para guia completo
- Verificar `ATUALIZACOES-NECESSARIAS.md` para contexto técnico
- Consultar logs do MikroTik via SSH

---

**Última atualização:** 21/10/2025
**Versão:** 1.0
**Status:** ✅ Pronto para deploy
