$(document).ready(function() {

    $.ajax({
        url: 'includes/menu.html',
        method: 'GET',
        dataType: 'html',
        success: function(response) {
            $('#mnu_super').append(response);
        },
        error: function() {
            $('footer').html('<p>Erro ao carregar o item.</p>');
        }
    });

    // Função para capturar o nome da página
    function capturarNomeDaPagina() {

        var caminhoCompleto = window.location.href;
        var partes          = caminhoCompleto.split("/");
        var nomePagina      = partes[partes.length - 1];
        return nomePagina || "index.html";
        
    }

    // Função para exibir um Toast
    function exibirToast(texto, classe, delay) {
        $.ajax({
            url: 'includes/toast.html',
            method: 'GET',
            dataType: 'html',
            success: function(response) {
                $('footer').append(response);
                $("#toast_push .toast-body").text(texto);
                $("#toast_push").addClass(classe);
                $("#toast_push").toast({ delay: delay }).toast("show");
            },
            error: function() {
                $('footer').html('<p>Erro ao carregar o item.</p>');
            }
        });
    }

    // Função para carregar o menu do cliente
    function carregarMenuCliente() {
        $.ajax({
            url: 'includes/menu_cliente.html',
            method: 'GET',
            dataType: 'html',
            success: function(response) {
                $('.mnu_cliente').append(response).removeAttr("hidden");
            },
            error: function() {
                $('footer').html('<p>Erro ao carregar o item.</p>');
            }
        });
    }

    // Função para carregar o conteúdo central do cliente
    function carregarConteudoCliente() {
        $.ajax({
            url: 'includes/conteudo_cliente.html',
            method: 'GET',
            dataType: 'html',
            success: function(response) {
                $('.conteudo_cliente').append(response);
            },
            error: function() {
                $('footer').html('<p>Erro ao carregar o item.</p>');
            }
        });
    }

    // Função para carregar o conteúdo central do cliente
    function carregarFormSignup() {
        $.ajax({
            url: 'includes/form_signup.html',
            method: 'GET',
            dataType: 'html',
            success: function(response) {

                $('#conteudo_pag').append(response);
                
                // MASCARA / VALIDAÇÃO PADRAO DOS CAMPOS

                $('.date').mask('00/00/0000');
                $('.time').mask('00:00:00');
                $('.date_time').mask('00/00/0000 00:00:00');
                $('.cep').mask('00000-000');
                $('.phone').mask('0000-0000');
                $('.phone_with_ddd').mask('(00) 00000-0000');
                $('.phone_us').mask('(000) 000-0000');
                $('.mixed').mask('AAA 000-S0S');
                $('.cpf').mask('000.000.000-00', {reverse: false});
                $('.cnpj').mask('00.000.000/0000-00', {reverse: true});
                $('.money').mask('000.000.000.000.000,00', {reverse: true});
                $('.money2').mask("#.##0,00", {reverse: true});
                $('.ip_address').mask('0ZZ.0ZZ.0ZZ.0ZZ', {
                translation: {
                    'Z': {
                    pattern: /[0-9]/, optional: true
                    }
                }
                });
                $('.ip_address').mask('099.099.099.099');
                $('.text_only').mask('AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA', {
                    translation: {
                        A: { pattern: /[A-Za-z]/ }
                    }
                });

                function validarEmail(email) {
                    var padraoEmail = /[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}/;
    
                    if (padraoEmail.test(email)) {
                        $('#campoEmail').removeClass('is-invalid').addClass('is-valid');
                    } else {
                        $('#campoEmail').removeClass('is-valid').addClass('is-invalid');
                    }
                }
                $(".email").on('blur', function() {
                    validarEmail($(this).val());
                });
    

            },
            error: function() {
                $('footer').html('<p>Erro ao carregar o item.</p>');
            }
        });
    }

    // Função para inicializar a contagem regressiva no modal
    function iniciarContagemRegressiva() {
        var countdownElement = $('#WXADS_MODAL .time_left');
        var closeButton = $('#WXADS_MODAL .btn_fecha_ads');
        var timeLeft = 5;

        function updateCountdown() {
            countdownElement.text(timeLeft);
            if (timeLeft === 0) {
                closeButton.removeAttr('hidden');
                $(".alr_splash").hide();
            } else {
                timeLeft--;
                setTimeout(updateCountdown, 1000);
            }
        }

        updateCountdown();
    }

    // Carregar instruções de execução com base na página atual
    var nomeDaPagina = capturarNomeDaPagina();
    var instrucoesExecucao = {
        "index.html": {
            "carregarMenuCliente"       : 1,
            "carregarModal"             : 1,
            "iniciarContagemRegressiva" : 0,
            "carregarConteudoCliente"   : 1,
            "tipoConteudo"              : 0,        //0 - IMAGEM / 1 - VÍDEO / 2 - HTML
            "srcConteudo"               : ""
        },
        "signup.html": {
            "carregarMenuCliente"       : 0,
            "carregarModalAlerta"       : 0,
            "carregarFormSignup"        : 1,
            "carregarConteudoCliente"   : 1,
            "tipoConteudo"              : 0,        //0 - IMAGEM / 1 - VÍDEO / 2 - HTML
            "srcConteudo"               : ""
        }
        // Adicione mais instruções conforme necessário
    };

    // Executar instruções de execução com base na página atual
    switch (nomeDaPagina) {

        case "index.html":

            if (instrucoesExecucao[nomeDaPagina].carregarMenuCliente) {

                carregarMenuCliente();

            }
            if (instrucoesExecucao[nomeDaPagina].carregarModal) {

                $.ajax({

                    url     : 'includes/modal.html',
                    method  : 'GET',
                    dataType: 'html',
                    success : function(response) {

                        $('footer').append(response);
                        $('#WXADS_MODAL').modal("show");
                        iniciarContagemRegressiva();

                    },
                    error   : function() {

                        $('footer').html('<p>Erro ao carregar o item.</p>');

                    }
                });
            }
            if (instrucoesExecucao[nomeDaPagina].carregarConteudoCliente) {

                carregarConteudoCliente();

            }

        break;

        case "home.html":

        break;
        
        case "signup.html":

            if (instrucoesExecucao[nomeDaPagina].carregarMenuCliente) {

                carregarMenuCliente();

            }
            if (instrucoesExecucao[nomeDaPagina].carregarFormSignup) {

                carregarFormSignup();

            }
            if (instrucoesExecucao[nomeDaPagina].carregarModalAlerta) {

                $.ajax({
                    url: 'includes/modal_alerta.html',
                    method: 'GET',
                    dataType: 'html',
                    success: function(response) {
                        $('footer').append(response);
                        $('#mdl_alerta').modal("show");
                    },
                    error: function() {
                        $('footer').html('<p>Erro ao carregar o item.</p>');
                    }
                });
            }

            var day;
            var month;
            var year;
            var dateArray = new Array();

            $(".select-birthday").change(function(){
                dateArray["day"]    = $("#select-day option:selected").val();
                dateArray["month"]  = $("#select-month option:selected").val(); 
                dateArray["year"]   = $("#select-year option:selected").val(); 
            });

            

        break;

        default:
    }
});
