@extends('layouts.auth')

@section('content')
<style>
    .form-control {
        color: #000 !important;
    }
</style>
    <div class="form-container ">
        <form class="app-form" method="POST" action="{{ route('login') }}">
            @csrf
            <div class="row">
                <div class="col-12">
                    <div class="mb-5 text-center text-lg-start">
                        <h2 class="text-white f-w-600">{{ __('Bem-vindo ao') }} <span class="text-dark">ki-admin!</span> </h2>
                        <p class="f-s-16 mt-2">{{ __('Faça login com os dados que você inseriu durante o registro') }}</p>
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-floating mb-3">
                        <input class="form-control" id="email" placeholder="Email" type="email" name="email" value="{{ old('email') }}" required autofocus>
                        <label for="email">{{ __('Email') }}</label>
                        @error('email')
                            <div class="text-danger mt-2">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-floating mb-3">
                        <input class="form-control" id="password" placeholder="Password" type="password" name="password" required autocomplete="current-password">
                        <label for="password">{{ __('Senha') }}</label>
                        @error('password')
                            <div class="text-danger mt-2">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="text-end ">
                        @if (Route::has('password.request'))
                            <a class="text-dark f-w-500 text-decoration-underline" href="{{ route('password.request') }}">{{ __('Esqueceu a senha?') }}</a>
                        @endif
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-check d-flex align-items-center gap-2 mb-3">
                        <input class="form-check-input w-25 h-25" id="remember_me" type="checkbox" name="remember">
                        <label class="form-check-label text-white mt-2 f-s-16 text-dark" for="remember_me">
                            {{ __('Lembre de mim') }}
                        </label>
                    </div>
                </div>
                <div class="col-12 mt-3">
                    <button type="submit" class="btn btn-primary btn-lg w-100">{{ __('Entrar') }}</button>
                </div>
                <div class="col-12 mt-4">
                    <div class="text-center text-lg-start f-w-500">
                        {{ __('Ainda não tem sua conta?') }}
                        <a class="text-white-800 text-decoration-underline" href="{{route('register')}}">{{ __('Inscrever-se') }}</a>
                    </div>
                </div>

                <div class="app-divider-v light justify-content-center py-lg-5 py-3">
                    <p>{{ __('OU') }}</p>
                </div>

                <div class="col-12">
                    <div class="d-flex gap-3 justify-content-center text-center">
                        <button class="btn btn-light-white  icon-btn w-45 h-45 b-r-15 " type="button">
                            <i class="ph-bold ph-facebook-logo f-s-20"></i>
                        </button>
                        <button class="btn btn-light-white  icon-btn w-45 h-45 b-r-15 " type="button">
                            <i class="ph-bold ph-google-logo f-s-20"></i>
                        </button>
                        <button class="btn btn-light-white  icon-btn w-45 h-45 b-r-15 " type="button">
                            <i class="ph-bold ph-twitter-logo f-s-20"></i>
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
