@extends('layouts.master')
@section('title', 'Nova Personalização')
@section('main-content')
    <div class="container-fluid">
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-palette f-s-16 me-2"></i>Nova Personalização</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li><a href="{{ route('customizations.index') }}" class="f-s-14 f-w-500">Personalização</a></li>
                    <li class="active"><a href="#" class="f-s-14 f-w-500">Nova</a></li>
                </ul>
            </div>
        </div>

        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Cadastrar Nova Personalização</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('customizations.store') }}" method="POST">
                            @csrf
                            @include('customizations._form')

                            <div class="row mt-4">
                                <div class="col-md-12 d-flex justify-content-end gap-2">
                                    <a href="{{ route('customizations.index') }}" class="btn btn-secondary">
                                        <i class="ph ph-arrow-left me-1"></i>Cancelar
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="ph ph-check me-1"></i>Salvar Personalização
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
