@extends('layouts.master')
@section('title', 'Personalização de Hotspots')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-palette f-s-16 me-2"></i>Personalização de Hotspots</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="#" class="f-s-14 f-w-500">
                            <span>Gestão de Hotspots</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Personalização</a>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Tabela -->
        <div class="row table-section">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5>Customizações Cadastradas</h5>
                            <div class="d-flex align-items-center gap-2">
                                <!-- Busca -->
                                <form action="{{ route('customizations.index') }}" method="GET" class="d-flex align-items-center gap-2">
                                    <div class="input-group">
                                        <select name="status" class="form-select" style="max-width: 120px;">
                                            <option value="">Todos</option>
                                            <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Ativos</option>
                                            <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inativos</option>
                                        </select>
                                    </div>
                                    <div class="input-group" style="min-width: 250px;">
                                        <input type="text"
                                               name="search"
                                               class="form-control"
                                               placeholder="Buscar hotspot..."
                                               value="{{ request('search') }}">
                                        <button type="submit" class="btn btn-secondary">
                                            <i class="ph ph-magnifying-glass me-1"></i>Buscar
                                        </button>
                                        @if(request('search') || request('status'))
                                            <a href="{{ route('customizations.index') }}" class="btn btn-outline-secondary">
                                                <i class="ph ph-x"></i>
                                            </a>
                                        @endif
                                    </div>
                                </form>

                                <!-- Botão Novo -->
                                <a href="{{ route('customizations.create') }}" class="btn btn-primary">
                                    <i class="ph ph-plus me-1"></i>Nova Personalização
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                <tr>
                                    <th scope="col" class="text-center" width="50">#</th>
                                    <th scope="col">Hotspot</th>
                                    <th scope="col">Marca / Logo</th>
                                    <th scope="col">Cor Primária</th>
                                    <th scope="col">Status</th>
                                    <th scope="col">Última Atualização</th>
                                    <th scope="col" class="text-center">Ações</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse($customizations as $index => $customization)
                                <tr>
                                    <td class="text-center">
                                        {{ ($customizations->currentPage() - 1) * $customizations->perPage() + $index + 1 }}
                                    </td>
                                    <td>
                                        <div>
                                            <code class="text-info" style="font-size: 0.95em; font-weight: 600;">
                                                {{ $customization->hotspot->serial }}
                                            </code>
                                            @if($customization->hotspot->nome)
                                                <div class="text-muted small">{{ $customization->hotspot->nome }}</div>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($customization->logo_url)
                                                <img src="{{ $customization->logo_url }}"
                                                     alt="Logo"
                                                     class="me-2"
                                                     style="max-height: 24px; max-width: 60px; object-fit: contain;">
                                            @endif
                                            <span>{{ $customization->brand_name }}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <div style="width: 30px; height: 30px; background-color: {{ $customization->primary_color }}; border: 1px solid #ddd; border-radius: 4px;"></div>
                                            <code class="small">{{ $customization->primary_color }}</code>
                                        </div>
                                    </td>
                                    <td>
                                        <form action="{{ route('customizations.toggle', $customization) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('PATCH')
                                            <button type="submit" class="btn btn-sm btn-{{ $customization->is_active ? 'success' : 'secondary' }}">
                                                <i class="ph ph-{{ $customization->is_active ? 'check-circle' : 'x-circle' }} me-1"></i>
                                                {{ $customization->is_active ? 'Ativo' : 'Inativo' }}
                                            </button>
                                        </form>
                                    </td>
                                    <td>
                                        <span class="text-muted small">
                                            {{ $customization->updated_at->format('d/m/Y H:i') }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('customizations.show', $customization) }}"
                                               class="btn btn-sm btn-info"
                                               title="Visualizar">
                                                <i class="ph ph-eye"></i>
                                            </a>
                                            <a href="{{ route('customizations.edit', $customization) }}"
                                               class="btn btn-sm btn-primary"
                                               title="Editar">
                                                <i class="ph ph-pencil"></i>
                                            </a>
                                            <a href="{{ route('customizations.preview', $customization) }}"
                                               class="btn btn-sm btn-secondary"
                                               target="_blank"
                                               title="Pré-visualizar Script">
                                                <i class="ph ph-code"></i>
                                            </a>
                                            <button type="button"
                                                    class="btn btn-sm btn-danger"
                                                    onclick="confirmDelete({{ $customization->id }})"
                                                    title="Excluir">
                                                <i class="ph ph-trash"></i>
                                            </button>
                                        </div>

                                        <form id="delete-form-{{ $customization->id }}"
                                              action="{{ route('customizations.destroy', $customization) }}"
                                              method="POST"
                                              style="display: none;">
                                            @csrf
                                            @method('DELETE')
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="ph ph-palette f-s-48"></i>
                                            <p class="mt-2">Nenhuma personalização cadastrada.</p>
                                            <a href="{{ route('customizations.create') }}" class="btn btn-sm btn-primary">
                                                <i class="ph ph-plus me-1"></i>Criar Primeira Personalização
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @if($customizations->hasPages())
                    <div class="card-footer">
                        {{ $customizations->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        function confirmDelete(id) {
            if (confirm('Tem certeza que deseja excluir esta personalização?')) {
                document.getElementById('delete-form-' + id).submit();
            }
        }
    </script>
    @endpush
@endsection
