<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro Aprovado</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f7fa;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .email-header {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            padding: 40px 30px;
            text-align: center;
            color: #ffffff;
        }
        .email-header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 600;
        }
        .email-header .icon {
            font-size: 64px;
            margin-bottom: 10px;
        }
        .email-body {
            padding: 40px 30px;
            color: #333333;
            line-height: 1.8;
        }
        .email-body h2 {
            color: #28a745;
            font-size: 22px;
            margin-top: 0;
            margin-bottom: 20px;
        }
        .info-box {
            background-color: #f8f9fa;
            border-left: 4px solid #28a745;
            padding: 20px;
            margin: 25px 0;
            border-radius: 4px;
        }
        .info-box p {
            margin: 8px 0;
            font-size: 14px;
        }
        .info-box strong {
            color: #495057;
            font-weight: 600;
        }
        .cta-button {
            display: inline-block;
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: #ffffff;
            padding: 14px 32px;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            font-size: 16px;
            margin: 20px 0;
            transition: transform 0.2s;
        }
        .cta-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(40, 167, 69, 0.3);
        }
        .email-footer {
            background-color: #f8f9fa;
            padding: 30px;
            text-align: center;
            color: #6c757d;
            font-size: 14px;
            border-top: 1px solid #dee2e6;
        }
        .email-footer p {
            margin: 8px 0;
        }
        .divider {
            height: 1px;
            background-color: #dee2e6;
            margin: 30px 0;
        }
        @media only screen and (max-width: 600px) {
            .email-container {
                margin: 20px;
            }
            .email-header, .email-body {
                padding: 30px 20px;
            }
            .email-header h1 {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Header -->
        <div class="email-header">
            <div class="icon">✅</div>
            <h1>Cadastro Aprovado!</h1>
        </div>

        <!-- Body -->
        <div class="email-body">
            <h2>Olá, {{ $userName }}!</h2>
            
            <p>
                Temos uma ótima notícia! Seu cadastro foi <strong>aprovado com sucesso</strong> 
                e agora você tem acesso completo ao sistema FreeFi Admin.
            </p>

            <div class="info-box">
                <p><strong>📧 E-mail:</strong> {{ $userEmail }}</p>
                <p><strong>🏢 Empresa:</strong> {{ $empresaNome }}</p>
                <p><strong>✅ Status:</strong> Aprovado</p>
            </div>

            <p>
                Você já pode fazer login e começar a utilizar todas as funcionalidades do sistema. 
                Clique no botão abaixo para acessar:
            </p>

            <center>
                <a href="{{ $loginUrl }}" class="cta-button">
                    Acessar Sistema
                </a>
            </center>

            <div class="divider"></div>

            <p style="color: #6c757d; font-size: 14px;">
                <strong>📌 Dica:</strong> Recomendamos que você altere sua senha no primeiro acesso 
                para garantir a segurança da sua conta.
            </p>

            <p style="margin-top: 30px;">
                Seja bem-vindo(a) ao FreeFi Admin! Se tiver alguma dúvida, nossa equipe de suporte 
                está à disposição para ajudá-lo(a).
            </p>
        </div>

        <!-- Footer -->
        <div class="email-footer">
            <p><strong>FreeFi Admin</strong></p>
            <p>Sistema de Gerenciamento de Franquias</p>
            <p style="margin-top: 20px; font-size: 12px; color: #868e96;">
                Este é um e-mail automático, por favor não responda.
            </p>
        </div>
    </div>
</body>
</html>
