<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro Rejeitado</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f7fa;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .email-header {
            background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
            padding: 40px 30px;
            text-align: center;
            color: #ffffff;
        }
        .email-header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 600;
        }
        .email-header .icon {
            font-size: 64px;
            margin-bottom: 10px;
        }
        .email-body {
            padding: 40px 30px;
            color: #333333;
            line-height: 1.8;
        }
        .email-body h2 {
            color: #dc3545;
            font-size: 22px;
            margin-top: 0;
            margin-bottom: 20px;
        }
        .info-box {
            background-color: #f8f9fa;
            border-left: 4px solid #dc3545;
            padding: 20px;
            margin: 25px 0;
            border-radius: 4px;
        }
        .info-box p {
            margin: 8px 0;
            font-size: 14px;
        }
        .info-box strong {
            color: #495057;
            font-weight: 600;
        }
        .alert-box {
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 20px;
            margin: 25px 0;
            border-radius: 4px;
        }
        .alert-box p {
            margin: 0;
            color: #856404;
            font-size: 14px;
        }
        .cta-button {
            display: inline-block;
            background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%);
            color: #ffffff;
            padding: 14px 32px;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            font-size: 16px;
            margin: 20px 0;
            transition: transform 0.2s;
        }
        .cta-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(108, 117, 125, 0.3);
        }
        .email-footer {
            background-color: #f8f9fa;
            padding: 30px;
            text-align: center;
            color: #6c757d;
            font-size: 14px;
            border-top: 1px solid #dee2e6;
        }
        .email-footer p {
            margin: 8px 0;
        }
        .divider {
            height: 1px;
            background-color: #dee2e6;
            margin: 30px 0;
        }
        @media only screen and (max-width: 600px) {
            .email-container {
                margin: 20px;
            }
            .email-header, .email-body {
                padding: 30px 20px;
            }
            .email-header h1 {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Header -->
        <div class="email-header">
            <div class="icon">❌</div>
            <h1>Cadastro Não Aprovado</h1>
        </div>

        <!-- Body -->
        <div class="email-body">
            <h2>Olá, {{ $userName }}</h2>
            
            <p>
                Lamentamos informar que seu cadastro no sistema FreeFi Admin 
                <strong>não foi aprovado</strong> neste momento.
            </p>

            <div class="info-box">
                <p><strong>📧 E-mail:</strong> {{ $userEmail }}</p>
                <p><strong>🏢 Empresa:</strong> {{ $empresaNome }}</p>
                <p><strong>❌ Status:</strong> Rejeitado</p>
            </div>

            @if($motivo)
            <div class="alert-box">
                <p><strong>📋 Motivo da Rejeição:</strong></p>
                <p style="margin-top: 10px;">{{ $motivo }}</p>
            </div>
            @endif

            <div class="divider"></div>

            <p>
                Se você acredita que houve algum engano ou deseja mais informações, 
                por favor entre em contato com nossa equipe de suporte.
            </p>

            <p style="color: #6c757d; font-size: 14px; margin-top: 25px;">
                <strong>💡 Próximos Passos:</strong><br>
                • Verifique os dados fornecidos no cadastro<br>
                • Entre em contato com o responsável pela sua empresa<br>
                • Aguarde orientações da equipe administrativa
            </p>

            <center>
                <a href="{{ $loginUrl }}" class="cta-button">
                    Tentar Novo Cadastro
                </a>
            </center>
        </div>

        <!-- Footer -->
        <div class="email-footer">
            <p><strong>FreeFi Admin</strong></p>
            <p>Sistema de Gerenciamento de Franquias</p>
            <p style="margin-top: 20px; font-size: 12px; color: #868e96;">
                Este é um e-mail automático, por favor não responda.
            </p>
        </div>
    </div>
</body>
</html>
