@extends('layouts.master')
@section('title', 'Empresas')
@section('main-content')
@use('Illuminate\Support\Facades\Storage')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-buildings f-s-16 me-2"></i>Empresas</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="#" class="f-s-14 f-w-500">
                            <span>Gestão de Empresas</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Empresas</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- tables start  -->
        <div class="row table-section">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5>Empresas Cadastradas</h5>
                            <div class="d-flex align-items-center gap-2">
                                <!-- Formulário de Busca -->
                                <form action="{{ route('empresas.index') }}" method="GET" class="d-flex">
                                    <div class="input-group" style="min-width: 300px;">
                                        <input type="text" 
                                               name="q" 
                                               id="search" 
                                               class="form-control" 
                                               placeholder="Buscar por nome..." 
                                               value="{{ request('q') }}">
                                        <button type="submit" class="btn btn-secondary">
                                            <i class="ph ph-magnifying-glass me-1"></i>Buscar
                                        </button>
                                        @if(request('q'))
                                            <a href="{{ route('empresas.index') }}" class="btn btn-outline-secondary" title="Limpar filtros">
                                                <i class="ph ph-x"></i>
                                            </a>
                                        @endif
                                    </div>
                                </form>
                                
                                <!-- Botões de Ação -->
                                <div class="btn-group">
                                    <a href="{{ route('empresas.create') }}" class="btn btn-primary">
                                        <i class="ph ph-plus me-1"></i>Nova Empresa
                                    </a>
                                    <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#trashModalEmpresas" title="Lixeira">
                                        <i class="ph ph-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                <tr>
                                    <th scope="col" class="text-center" width="50">#</th>
                                    <th scope="col">Nome</th>
                                    <th scope="col">Tipo</th>
                                    <th scope="col">Código de Convite</th>
                                    <th scope="col">E-mail</th>
                                    <th scope="col">Telefone</th>
                                    <th scope="col" class="text-center">Ações</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse($empresas as $index => $empresa)
                                <tr class="@if($empresa->status == 1) text-muted @endif">
                                    <td class="text-center">{{ ($empresas->currentPage() - 1) * $empresas->perPage() + $index + 1 }}</td>
                                    <td><a href="{{ route('empresas.edit', $empresa) }}" class="text-decoration-none text-reset">{{ $empresa->name }}</a></td>
                                    <td>
                                        @if($empresa->tipo_empresa === 'matriz')
                                            <span class="badge bg-primary">
                                                <i class="ph ph-crown me-1"></i>Matriz
                                            </span>
                                        @elseif($empresa->tipo_empresa === 'franquia')
                                            <span class="badge bg-info">
                                                <i class="ph ph-buildings me-1"></i>Franquia
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">
                                                <i class="ph ph-storefront me-1"></i>Cliente
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($empresa->codigo_convite)
                                            <code class="text-primary fw-bold" style="font-size: 0.9rem; cursor: pointer;" 
                                                  onclick="copyToClipboard('{{ $empresa->codigo_convite }}')" 
                                                  title="Clique para copiar">
                                                {{ $empresa->codigo_convite }}
                                            </code>
                                            <i class="ph ph-copy text-muted ms-1" style="font-size: 0.8rem;"></i>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>{{ $empresa->email }}</td>
                                    <td>{{ $empresa->phone }}</td>
                                    <td class="text-center">
                                        @if($empresa->logomarca)
                                            <a href="#" class="preview-media me-2" data-bs-toggle="modal" data-bs-target="#mediaPreviewModal" data-path="{{ Storage::url($empresa->logomarca) }}" data-type="image" title="Preview Logomarca">
                                                <i class="ph-duotone ph-eye"></i>
                                            </a>
                                        @endif
                                        <a href="#" class="toggle-status me-2" data-id="{{ $empresa->id }}" title="Mudar Status">
                                            @if($empresa->status == 0)
                                                <i class="ph-bold ph-toggle-right text-success"></i>
                                            @else
                                                <i class="ph-bold ph-toggle-left"></i>
                                            @endif
                                        </a>
                                        <a href="#" class="delete-empresa" data-id="{{ $empresa->id }}" title="Excluir">
                                            <i class="ph-duotone ph-trash"></i>
                                        </a>
                                        <form id="delete-form-{{ $empresa->id }}" action="{{ route('empresas.destroy', $empresa) }}" method="POST" style="display: none;">
                                            @csrf
                                            @method('DELETE')
                                        </form>
                                        <form id="toggle-status-form-{{ $empresa->id }}" action="{{ route('empresas.toggleStatus', $empresa) }}" method="POST" style="display: none;">
                                            @csrf
                                            @method('PATCH')
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">Nenhuma empresa encontrada.</td>
                                </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @if ($empresas->hasPages())
                        <div class="card-footer">
                            {{ $empresas->appends(request()->query())->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
        <!-- tables-end  -->
    </div>

    <!-- Trash Modal -->
    <div class="modal fade" id="trashModalEmpresas" tabindex="-1" aria-labelledby="trashModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="trashModalLabel">Empresas Excluídas</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="trashModalBodyEmpresas">
                    <p>Carregando...</p>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    // Função para copiar código de convite
    function copyToClipboard(text) {
        // Função para mostrar tooltip de sucesso
        function showTooltip(clientX, clientY) {
            const tooltip = document.createElement('div');
            tooltip.textContent = '✓ Copiado!';
            tooltip.style.position = 'fixed';
            tooltip.style.top = clientY + 'px';
            tooltip.style.left = clientX + 'px';
            tooltip.style.backgroundColor = '#198754';
            tooltip.style.color = 'white';
            tooltip.style.padding = '5px 10px';
            tooltip.style.borderRadius = '4px';
            tooltip.style.fontSize = '12px';
            tooltip.style.zIndex = '9999';
            document.body.appendChild(tooltip);

            setTimeout(() => {
                tooltip.remove();
            }, 1500);
        }

        // Tentar usar clipboard API se disponível (HTTPS)
        if (navigator.clipboard && navigator.clipboard.writeText) {
            navigator.clipboard.writeText(text).then(function() {
                showTooltip(event.clientX, event.clientY);
            }).catch(function(err) {
                console.error('Erro ao copiar com clipboard API: ', err);
                fallbackCopy(text);
            });
        } else {
            // Fallback para HTTP usando método tradicional
            fallbackCopy(text);
        }

        function fallbackCopy(text) {
            const textArea = document.createElement('textarea');
            textArea.value = text;
            textArea.style.position = 'fixed';
            textArea.style.top = '0';
            textArea.style.left = '0';
            textArea.style.width = '2em';
            textArea.style.height = '2em';
            textArea.style.padding = '0';
            textArea.style.border = 'none';
            textArea.style.outline = 'none';
            textArea.style.boxShadow = 'none';
            textArea.style.background = 'transparent';
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();

            try {
                const successful = document.execCommand('copy');
                if (successful) {
                    showTooltip(event.clientX, event.clientY);
                } else {
                    alert('Não foi possível copiar. Por favor, copie manualmente: ' + text);
                }
            } catch (err) {
                console.error('Erro ao copiar: ', err);
                alert('Não foi possível copiar. Por favor, copie manualmente: ' + text);
            }

            document.body.removeChild(textArea);
        }
    }
    
    document.addEventListener('DOMContentLoaded', function () {
        // Main page actions
        document.body.addEventListener('click', function(event) {
            if (event.target.closest('.delete-empresa')) {
                event.preventDefault();
                let empresaId = event.target.closest('.delete-empresa').dataset.id;
                if (confirm('Tem certeza que deseja enviar esta empresa para a lixeira?')) {
                    document.getElementById('delete-form-' + empresaId).submit();
                }
            }
            if (event.target.closest('.toggle-status')) {
                event.preventDefault();
                let empresaId = event.target.closest('.toggle-status').dataset.id;
                document.getElementById('toggle-status-form-' + empresaId).submit();
            }
        });

        // Trash Modal for Empresas
        const trashModalEmpresas = document.getElementById('trashModalEmpresas');
        if(trashModalEmpresas) {
            trashModalEmpresas.addEventListener('show.bs.modal', function () {
                const modalBody = document.getElementById('trashModalBodyEmpresas');
                modalBody.innerHTML = '<p>Carregando...</p>';

                fetch('{{ route("empresas.trash") }}')
                    .then(response => response.json())
                    .then(data => {
                        if (data.length === 0) {
                            modalBody.innerHTML = '<p>A lixeira está vazia.</p>';
                            return;
                        }

                        let tableHtml = '<div class="table-responsive"><table class="table align-middle"><thead><tr><th>Empresa</th><th>Excluído em</th><th>Excluído por</th><th>Ações</th></tr></thead><tbody>';
                        data.forEach(empresa => {
                            const deletedAt = new Date(empresa.deleted_at).toLocaleString('pt-BR');
                            const destroyerName = empresa.destroyer ? empresa.destroyer.name : 'Usuário desconhecido';

                            tableHtml += `
                                <tr>
                                    <td>${empresa.name}</td>
                                    <td>${deletedAt}</td>
                                    <td>${destroyerName}</td>
                                    <td>
                                        <button class="btn btn-sm btn-success restore-empresa" data-id="${empresa.id}">Restaurar</button>
                                        <form id="restore-form-${empresa.id}" action="/empresas/${empresa.id}/restore" method="POST" style="display: none;">
                                            @csrf
                                            @method('PATCH')
                                        </form>
                                    </td>
                                </tr>
                            `;
                        });
                        tableHtml += '</tbody></table></div>';
                        modalBody.innerHTML = tableHtml;
                    })
                    .catch(error => {
                        modalBody.innerHTML = '<p>Ocorreu um erro ao carregar os itens.</p>';
                        console.error('Error fetching trash:', error);
                    });
            });

            trashModalEmpresas.addEventListener('click', function(event) {
                const restoreBtn = event.target.closest('.restore-empresa');
                if (restoreBtn) {
                    event.preventDefault();
                    let empresaId = restoreBtn.dataset.id;
                    if (confirm('Tem certeza que deseja restaurar esta empresa?')) {
                        document.getElementById('restore-form-' + empresaId).submit();
                    }
                }
            });
        }
    });
</script>
@endpush
