@extends('layouts.master')
@section('title', isset($group) ? 'Edit Group' : 'Create Group')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5>@yield('title')</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="{{ route('groups.index') }}" class="f-s-14 f-w-500">
                            <span><i class="ph-duotone ph-users-three f-s-16"></i> Groups</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">@yield('title')</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Group Details</h5>
                    </div>
                    <div class="card-body">
                        <form class="app-form" action="{{ isset($group) ? route('groups.update', $group) : route('groups.store') }}" method="POST">
                            @csrf
                            @if(isset($group))
                                @method('PUT')
                            @endif
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Name</label>
                                        <input type="text" name="name" class="form-control" placeholder="e.g., Administrator" value="{{ old('name', $group->name ?? '') }}" required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Description</label>
                                        <input type="text" name="description" class="form-control" placeholder="A short description" value="{{ old('description', $group->description ?? '') }}">
                                    </div>
                                </div>

                                <div class="col-12 text-end">
                                    <button type="submit" class="btn btn-success">Submit</button>
                                    <a href="{{ route('groups.index') }}" class="btn btn-secondary">Cancel</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
