@extends('layouts.master')
@section('title', 'Novo Hotspot')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5>@yield('title')</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="{{ route('hotspots.index') }}" class="f-s-14 f-w-500">
                            <span><i class="ph-duotone ph-wifi-high f-s-16"></i> Hotspots</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">@yield('title')</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Detalhes do Hotspot</h5>
                    </div>
                    <div class="card-body">
                        <form class="app-form" action="{{ route('hotspots.store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Marca <span class="text-danger">*</span></label>
                                        <input type="text" name="marca" class="form-control @error('marca') is-invalid @enderror" placeholder="Ex: Mikrotik, Ubiquiti, TP-Link" value="{{ old('marca') }}" required>
                                        @error('marca')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Modelo <span class="text-danger">*</span></label>
                                        <input type="text" name="modelo" class="form-control @error('modelo') is-invalid @enderror" placeholder="Ex: hAP ac2, UniFi AP AC Lite" value="{{ old('modelo') }}" required>
                                        @error('modelo')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Serial <span class="text-danger">*</span></label>
                                        <input type="text" name="serial" class="form-control @error('serial') is-invalid @enderror" placeholder="Número de série único" value="{{ old('serial') }}" required>
                                        @error('serial')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Franquia (Gerenciadora)</label>
                                        <select name="franquia_id" class="form-select @error('franquia_id') is-invalid @enderror">
                                            <option value="">Nenhuma</option>
                                            @foreach($empresas->where('tipo_empresa', 'franquia') as $empresa)
                                                <option value="{{ $empresa->id }}" {{ old('franquia_id') == $empresa->id ? 'selected' : '' }}>
                                                    {{ $empresa->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <small class="form-text text-muted">Franquia responsável pelo gerenciamento do hotspot</small>
                                        @error('franquia_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Cliente (Localização)</label>
                                        <select name="cliente_id" class="form-select @error('cliente_id') is-invalid @enderror">
                                            <option value="">Nenhum</option>
                                            @foreach($empresas->where('tipo_empresa', 'cliente') as $empresa)
                                                <option value="{{ $empresa->id }}" {{ old('cliente_id') == $empresa->id ? 'selected' : '' }}>
                                                    {{ $empresa->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <small class="form-text text-muted">Cliente onde o hotspot está instalado</small>
                                        @error('cliente_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Situação</label>
                                        <select name="situacao" class="form-select @error('situacao') is-invalid @enderror">
                                            <option value="estoque" {{ old('situacao') == 'estoque' ? 'selected' : '' }}>📦 Estoque</option>
                                            <option value="em_transito" {{ old('situacao') == 'em_transito' ? 'selected' : '' }}>🚚 Em Trânsito</option>
                                            <option value="aguardando_instalacao" {{ old('situacao') == 'aguardando_instalacao' ? 'selected' : '' }}>⏳ Aguardando Instalação</option>
                                            <option value="instalado" {{ old('situacao', 'instalado') == 'instalado' ? 'selected' : '' }}>✅ Instalado</option>
                                            <option value="manutencao" {{ old('situacao') == 'manutencao' ? 'selected' : '' }}>🔧 Manutenção</option>
                                            <option value="desativado" {{ old('situacao') == 'desativado' ? 'selected' : '' }}>❌ Desativado</option>
                                        </select>
                                        <small class="form-text text-muted">Status logístico do equipamento</small>
                                        @error('situacao')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Configurações VPN -->
                                <div class="col-12">
                                    <hr class="my-4">
                                    <h6 class="text-primary mb-3"><i class="ph-duotone ph-lock-key me-2"></i>Configurações VPN (Automação)</h6>
                                </div>

                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label">IP VPN</label>
                                        <input type="text" name="vpn_ip" class="form-control @error('vpn_ip') is-invalid @enderror" placeholder="Ex: 10.8.0.10" value="{{ old('vpn_ip') }}">
                                        <small class="form-text text-muted">IP do hotspot na VPN</small>
                                        @error('vpn_ip')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label">Login VPN</label>
                                        <input type="text" name="vpn_login" class="form-control @error('vpn_login') is-invalid @enderror" placeholder="Usuário de acesso" value="{{ old('vpn_login') }}">
                                        <small class="form-text text-muted">Usuário para acesso remoto</small>
                                        @error('vpn_login')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label">Senha VPN</label>
                                        <input type="password" name="vpn_password" class="form-control @error('vpn_password') is-invalid @enderror" placeholder="Senha de acesso" value="{{ old('vpn_password') }}">
                                        <small class="form-text text-muted">Senha para acesso remoto</small>
                                        @error('vpn_password')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-12 text-end">
                                    <div class="btn-group" role="group">
                                        <button type="submit" class="btn btn-success"><i class="ph-duotone ph-floppy-disk me-2"></i>Salvar</button>
                                        <a href="{{ route('hotspots.index') }}" class="btn btn-secondary"><i class="ph-duotone ph-x-circle me-2"></i>Cancelar</a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
