<?php

use App\Http\Controllers\Api\HotspotApiController;
use App\Http\Controllers\PublicacaoController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Rotas de API para comunicação com hotspots e aplicações externas.
| Utiliza autenticação via Laravel Sanctum (tokens).
|
*/

// Rota de teste
Route::get('/test', function () {
    return response()->json([
        'success' => true,
        'message' => 'API FreeFi Admin funcionando!',
        'version' => '1.0.0',
        'timestamp' => now()->toIso8601String(),
    ]);
});

// Rotas públicas (sem autenticação) - para hotspots
Route::prefix('hotspot')->name('api.hotspot.')->group(function () {
    
    // Heartbeat - Hotspot informa que está online
    Route::post('heartbeat', [HotspotApiController::class, 'heartbeat'])
        ->name('heartbeat');
    
    // Buscar publicações vigentes para o hotspot
    Route::get('{serial}/publicacoes', [HotspotApiController::class, 'publicacoes'])
        ->name('publicacoes');
    
    // Buscar walled gardens de uma publicação
    Route::get('publicacao/{id}/walled-gardens', [HotspotApiController::class, 'walledGardens'])
        ->name('walled-gardens');
    
    // Registrar impressão de anúncio
    Route::post('impressao', [HotspotApiController::class, 'registrarImpressao'])
        ->name('impressao');
    
    // Registrar clique em anúncio
    Route::post('clique', [HotspotApiController::class, 'registrarClique'])
        ->name('clique');
});

// Rotas protegidas (requerem autenticação Sanctum)
Route::middleware('auth:sanctum')->group(function () {
    
    // Informações do usuário autenticado
    Route::get('/user', function (Request $request) {
        return $request->user();
    });
    
    // Estatísticas (para painel administrativo ou apps mobile)
    Route::prefix('publicacoes')->name('api.publicacoes.')->group(function () {
        Route::post('{id}/impressao', [PublicacaoController::class, 'registrarImpressao'])
            ->name('registrar-impressao');
        Route::post('{id}/clique', [PublicacaoController::class, 'registrarClique'])
            ->name('registrar-clique');
    });
});
