<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\LocaleController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\EmpresaController;
use App\Http\Controllers\MidiaController;
use App\Http\Controllers\HotspotController;
use App\Http\Controllers\HotspotCustomizationController;
use App\Http\Controllers\PublicacaoController;
use App\Http\Controllers\EstatisticasController;
use App\Http\Controllers\DebugController;
use App\Http\Controllers\Auth\RegisterController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

// Página de testes de interface (apenas em desenvolvimento)
Route::get('/teste-interface', function () {
    return view('teste-interface');
})->name('teste.interface');

Route::get('locale/{locale}', [LocaleController::class, 'setLocale'])->name('locale.setting');

// ==========================================
// REGISTRO COM CÓDIGO DE CONVITE (Guest)
// ==========================================
Route::middleware('guest')->group(function () {
    Route::get('/register', [RegisterController::class, 'showForm'])->name('register');
    Route::post('/register', [RegisterController::class, 'register'])->name('register.store');
    Route::post('/register/validate-code', [RegisterController::class, 'validateCode'])->name('register.validate-code');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified', 'check.approval'])->name('dashboard');

Route::middleware(['auth', 'check.approval'])->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // User Management
    Route::get('users/trash', [UserController::class, 'trash'])->name('users.trash');
    Route::patch('users/{id}/restore', [UserController::class, 'restore'])->name('users.restore');
    Route::patch('users/{user}/approve', [UserController::class, 'approve'])->name('users.approve');
    Route::patch('users/{user}/reject', [UserController::class, 'reject'])->name('users.reject');
    Route::resource('users', UserController::class);

    // RBAC Routes
    Route::resource('permissions', PermissionController::class);
    Route::resource('groups', GroupController::class);
    Route::get('groups/{group}/permissions', [GroupController::class,'editPermissions'])->name('groups.permissions.edit');
    Route::post('groups/{group}/permissions', [GroupController::class,'updatePermissions'])->name('groups.permissions.update');

    // Media Management
    Route::get('empresas/trash', [EmpresaController::class, 'trash'])->name('empresas.trash');
    Route::patch('empresas/{id}/restore', [EmpresaController::class, 'restore'])->name('empresas.restore');
    Route::patch('empresas/{empresa}/status', [EmpresaController::class, 'toggleStatus'])->name('empresas.toggleStatus');
    Route::resource('empresas', EmpresaController::class);
    Route::get('midias/trash', [MidiaController::class, 'trash'])->name('midias.trash');
    Route::patch('midias/{midia}/restore', [MidiaController::class, 'restore'])->name('midias.restore');
    Route::patch('midias/{midia}/status', [MidiaController::class, 'toggleStatus'])->name('midias.toggleStatus');
    Route::resource('midias', MidiaController::class);
    
    // Hotspots Management
    Route::get('hotspots/trash', [HotspotController::class, 'trash'])->name('hotspots.trash');
    Route::patch('hotspots/{id}/restore', [HotspotController::class, 'restore'])->name('hotspots.restore');
    Route::patch('hotspots/{hotspot}/status', [HotspotController::class, 'toggleStatus'])->name('hotspots.toggleStatus');
    Route::patch('hotspots/{hotspot}/situacao', [HotspotController::class, 'updateSituacao'])->name('hotspots.updateSituacao');
    Route::resource('hotspots', HotspotController::class);

    // Hotspot Customizations Management
    Route::get('customizations/{customization}/preview', [HotspotCustomizationController::class, 'preview'])->name('customizations.preview');
    Route::patch('customizations/{customization}/toggle', [HotspotCustomizationController::class, 'toggle'])->name('customizations.toggle');
    Route::resource('customizations', HotspotCustomizationController::class);
    
    // Publicações Management
    Route::get('publicacoes/criativo/{id}', [PublicacaoController::class, 'buscarCriativo'])->name('publicacoes.buscarCriativo');
    Route::get('publicacoes/{publicacao}/estatisticas', [PublicacaoController::class, 'estatisticas'])->name('publicacoes.estatisticas');
    Route::get('publicacoes/{publicacao}/analytics-json', [PublicacaoController::class, 'analyticsJson'])->name('publicacoes.analyticsJson');
    Route::patch('publicacoes/{publicacao}/status', [PublicacaoController::class, 'toggleStatus'])->name('publicacoes.toggleStatus');
    Route::resource('publicacoes', PublicacaoController::class)->parameters(['publicacoes' => 'publicacao']);
    
    // Estatísticas
    Route::prefix('estatisticas')->name('estatisticas.')->group(function () {
        Route::get('dashboard', [EstatisticasController::class, 'dashboard'])->name('dashboard');
        Route::get('por-publicacao', [EstatisticasController::class, 'porPublicacao'])->name('por-publicacao');
        Route::get('por-hotspot', [EstatisticasController::class, 'porHotspot'])->name('por-hotspot');
        Route::get('graficos-json', [EstatisticasController::class, 'graficosJson'])->name('graficos-json');
    });
    
    // API para incrementar visualizações (pode ser movida para api.php se necessário)
    Route::post('api/publicacoes/{id}/visualizacoes', [PublicacaoController::class, 'incrementarVisualizacoes'])->name('api.publicacoes.incrementarVisualizacoes');

    // Debug - Auditoria Splash (remover em produção)
    Route::get('debug/auditoria-splash', [DebugController::class, 'auditoriaSplash'])->name('debug.auditoria-splash');
});

require __DIR__.'/auth.php';
