#!/bin/bash

# Script para executar todos os testes do módulo de personalização
# Data: 2025-11-03

echo "════════════════════════════════════════════════════════════"
echo "🧪 SUITE COMPLETA DE TESTES - Módulo de Personalização"
echo "════════════════════════════════════════════════════════════"
echo ""

# Cores
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# Contadores
TOTAL_TESTS=0
PASSED_TESTS=0
FAILED_TESTS=0

# Função para executar teste
run_test() {
    local test_name=$1
    local test_file=$2

    echo -e "${BLUE}────────────────────────────────────────────────────────────${NC}"
    echo -e "${YELLOW}▶ Executando: $test_name${NC}"
    echo -e "${BLUE}────────────────────────────────────────────────────────────${NC}"
    echo ""

    # Executar teste com PHP 8.3
    /usr/bin/php8.3 artisan test "$test_file" --colors=always

    local exit_code=$?

    if [ $exit_code -eq 0 ]; then
        echo -e "${GREEN}✅ $test_name - PASSOU${NC}"
        ((PASSED_TESTS++))
    else
        echo -e "${RED}❌ $test_name - FALHOU${NC}"
        ((FAILED_TESTS++))
    fi

    ((TOTAL_TESTS++))
    echo ""
}

# Verificar se estamos no diretório correto
if [ ! -f "artisan" ]; then
    echo -e "${RED}❌ Erro: Execute este script no diretório raiz do Laravel${NC}"
    exit 1
fi

# Verificar se PHP 8.3 está disponível
if [ ! -f "/usr/bin/php8.3" ]; then
    echo -e "${RED}❌ Erro: PHP 8.3 não encontrado${NC}"
    exit 1
fi

echo -e "${BLUE}📋 Preparação do ambiente de testes...${NC}"
echo ""

# Criar banco de teste (se necessário)
echo "🔧 Configurando banco de testes..."
/usr/bin/php8.3 artisan config:cache 2>/dev/null || true
echo ""

# Executar todos os testes

echo -e "${BLUE}═══════════════════════════════════════════════════════════${NC}"
echo -e "${YELLOW}📦 1. TESTES UNITÁRIOS${NC}"
echo -e "${BLUE}═══════════════════════════════════════════════════════════${NC}"
echo ""

run_test "Model HotspotCustomization" "tests/Unit/HotspotCustomizationTest.php"

echo -e "${BLUE}═══════════════════════════════════════════════════════════${NC}"
echo -e "${YELLOW}🔌 2. TESTES DE INTEGRAÇÃO (API)${NC}"
echo -e "${BLUE}═══════════════════════════════════════════════════════════${NC}"
echo ""

run_test "API CustomizationController" "tests/Feature/Api/CustomizationControllerTest.php"

echo -e "${BLUE}═══════════════════════════════════════════════════════════${NC}"
echo -e "${YELLOW}🌐 3. TESTES END-TO-END${NC}"
echo -e "${BLUE}═══════════════════════════════════════════════════════════${NC}"
echo ""

run_test "Fluxo Completo E2E" "tests/Feature/HotspotCustomizationE2ETest.php"

# Relatório Final
echo ""
echo ""
echo "════════════════════════════════════════════════════════════"
echo -e "${YELLOW}📊 RELATÓRIO FINAL DOS TESTES${NC}"
echo "════════════════════════════════════════════════════════════"
echo ""
echo -e "Total de Suites:    ${BLUE}$TOTAL_TESTS${NC}"
echo -e "Suites Aprovadas:   ${GREEN}$PASSED_TESTS${NC}"
echo -e "Suites Falhadas:    ${RED}$FAILED_TESTS${NC}"
echo ""

if [ $FAILED_TESTS -eq 0 ]; then
    echo -e "${GREEN}╔═══════════════════════════════════════════════════════╗${NC}"
    echo -e "${GREEN}║                                                       ║${NC}"
    echo -e "${GREEN}║   ✅  TODOS OS TESTES PASSARAM COM SUCESSO!  ✅     ║${NC}"
    echo -e "${GREEN}║                                                       ║${NC}"
    echo -e "${GREEN}╚═══════════════════════════════════════════════════════╝${NC}"
    echo ""
    echo -e "${GREEN}🎉 O módulo de personalização está 100% funcional!${NC}"
    exit 0
else
    echo -e "${RED}╔═══════════════════════════════════════════════════════╗${NC}"
    echo -e "${RED}║                                                       ║${NC}"
    echo -e "${RED}║   ❌  ALGUNS TESTES FALHARAM  ❌                    ║${NC}"
    echo -e "${RED}║                                                       ║${NC}"
    echo -e "${RED}╚═══════════════════════════════════════════════════════╝${NC}"
    echo ""
    echo -e "${YELLOW}⚠️  Verifique os logs acima para mais detalhes.${NC}"
    exit 1
fi
