# ============================================
# FreeFi - Script de Heartbeat
# ============================================
# 
# PROPÓSITO:
# Envia heartbeat para API Laravel a cada 5 minutos
# Atualiza campo last_activity_at no banco de dados
# Permite monitoramento de hotspots online
#
# INSTALAÇÃO:
# 1. Copiar este arquivo via FTP/WinBox para Mikrotik
# 2. Importar: /import 1_freefi_heartbeat.rsc
# 3. Ou copiar/colar direto no Terminal
#
# AGENDAMENTO:
# Executar script 2_freefi_scheduler.rsc após este
#
# DATA: 2025-10-20
# ============================================

/system script add name=freefi_heartbeat source={
  # ============================================
  # CONFIGURAÇÕES
  # ============================================
  
  # URL da API Laravel (ajustar conforme ambiente)
  :local apiUrl "https://admin.freefi.com.br/api/hotspot/heartbeat";
  
  # Se usar HTTP local (desenvolvimento):
  # :local apiUrl "http://192.168.1.100/api/hotspot/heartbeat";
  
  # ============================================
  # COLETA DE DADOS DO MIKROTIK
  # ============================================
  
  # Serial (Identity do Mikrotik)
  :local serial [/system identity get name];
  
  # IP da VPN (ajustar interface conforme configuração)
  :local vpnip "";
  :if ([/interface find name="vpn"] != "") do={
    :set vpnip [/ip address get [find interface="vpn"] address];
  } else={
    :set vpnip "N/A";
  }
  
  # ============================================
  # ENVIO DO HEARTBEAT
  # ============================================
  
  :do {
    /tool fetch \
      url=$apiUrl \
      http-method=post \
      http-header-field="Content-Type: application/json" \
      http-data="{\"serial\":\"$serial\",\"vpn_ip\":\"$vpnip\"}" \
      keep-result=no \
      output=none;
    
    :log info ("FreeFi: Heartbeat enviado - Serial: " . $serial . " | VPN: " . $vpnip);
    
  } on-error={
    :log error "FreeFi: Erro ao enviar heartbeat. Verificar conectividade e URL da API.";
  }
}

# ============================================
# FIM DO SCRIPT
# ============================================

:put "✅ Script 'freefi_heartbeat' criado com sucesso!"
:put "📋 Próximo passo: Importar script de agendamento (2_freefi_scheduler.rsc)"
