<?php $__env->startSection('title', 'Debug - Auditoria Splash'); ?>

<?php $__env->startSection('main-content'); ?>
    <div class="container-fluid mt-5">
        <div class="row">
            <div class="col-12">
                <h2>Dados da Tabela: auditoria_splash</h2>
                <hr>
                
                <div class="alert alert-info">
                    <strong>Total de registros encontrados:</strong> <?php echo e($dados->count()); ?>

                </div>

                <?php if($dados->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>ID</th>
                                    <th>HS Serial</th>
                                    <th>MAC Address</th>
                                    <th>Página Clicada</th>
                                    <th>Imagem</th>
                                    <th>Identity</th>
                                    <th>Data/Hora</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $dados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><strong><?php echo e($item->id); ?></strong></td>
                                        <td>
                                            <code><?php echo e($item->hs_serial ?? '---'); ?></code>
                                        </td>
                                        <td>
                                            <code class="text-muted"><?php echo e($item->mac_formatado); ?></code>
                                        </td>
                                        <td>
                                            <a href="<?php echo e($item->pag_click); ?>" target="_blank" rel="noopener">
                                                <?php echo e(Str::limit($item->pag_click ?? '---', 50)); ?>

                                            </a>
                                        </td>
                                        <td>
                                            <?php echo e(Str::limit($item->imagem ?? '---', 30)); ?>

                                        </td>
                                        <td>
                                            <small class="text-muted"><?php echo e($item->dsc_identity ?? '---'); ?></small>
                                        </td>
                                        <td>
                                            <small><?php echo e($item->created_at?->format('d/m/Y H:i:s') ?? '---'); ?></small>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <hr>
                    <h4>Dados em JSON (últimos 5):</h4>
                    <pre class="bg-light p-3 rounded"><code><?php echo e(json_encode($dados->take(5)->toArray(), JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES)); ?></code></pre>
                <?php else: ?>
                    <div class="alert alert-warning">
                        <i class="ph-duotone ph-warning me-2"></i>
                        Nenhum registro encontrado na tabela.
                    </div>
                <?php endif; ?>

                <hr>
                <a href="<?php echo e(route('publicacoes.index')); ?>" class="btn btn-secondary">
                    <i class="ph-duotone ph-arrow-left me-2"></i>Voltar
                </a>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/resources/views/debug/auditoria-splash.blade.php ENDPATH**/ ?>