<?php $__env->startSection('title', 'Empresas'); ?>
<?php $__env->startSection('main-content'); ?>
<?php use \Illuminate\Support\Facades\Storage; ?>
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-buildings f-s-16 me-2"></i>Empresas</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="#" class="f-s-14 f-w-500">
                            <span>Gestão de Empresas</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Empresas</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- tables start  -->
        <div class="row table-section">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5>Empresas Cadastradas</h5>
                            <div class="d-flex align-items-center gap-2">
                                <!-- Formulário de Busca -->
                                <form action="<?php echo e(route('empresas.index')); ?>" method="GET" class="d-flex">
                                    <div class="input-group" style="min-width: 300px;">
                                        <input type="text" 
                                               name="q" 
                                               id="search" 
                                               class="form-control" 
                                               placeholder="Buscar por nome..." 
                                               value="<?php echo e(request('q')); ?>">
                                        <button type="submit" class="btn btn-secondary">
                                            <i class="ph ph-magnifying-glass me-1"></i>Buscar
                                        </button>
                                        <?php if(request('q')): ?>
                                            <a href="<?php echo e(route('empresas.index')); ?>" class="btn btn-outline-secondary" title="Limpar filtros">
                                                <i class="ph ph-x"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </form>
                                
                                <!-- Botões de Ação -->
                                <div class="btn-group">
                                    <a href="<?php echo e(route('empresas.create')); ?>" class="btn btn-primary">
                                        <i class="ph ph-plus me-1"></i>Nova Empresa
                                    </a>
                                    <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#trashModalEmpresas" title="Lixeira">
                                        <i class="ph ph-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                <tr>
                                    <th scope="col" class="text-center" width="50">#</th>
                                    <th scope="col">Nome</th>
                                    <th scope="col">Tipo</th>
                                    <th scope="col">Código de Convite</th>
                                    <th scope="col">E-mail</th>
                                    <th scope="col">Telefone</th>
                                    <th scope="col" class="text-center">Ações</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="<?php if($empresa->status == 1): ?> text-muted <?php endif; ?>">
                                    <td class="text-center"><?php echo e(($empresas->currentPage() - 1) * $empresas->perPage() + $index + 1); ?></td>
                                    <td><a href="<?php echo e(route('empresas.edit', $empresa)); ?>" class="text-decoration-none text-reset"><?php echo e($empresa->name); ?></a></td>
                                    <td>
                                        <?php if($empresa->tipo_empresa === 'matriz'): ?>
                                            <span class="badge bg-primary">
                                                <i class="ph ph-crown me-1"></i>Matriz
                                            </span>
                                        <?php elseif($empresa->tipo_empresa === 'franquia'): ?>
                                            <span class="badge bg-info">
                                                <i class="ph ph-buildings me-1"></i>Franquia
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">
                                                <i class="ph ph-storefront me-1"></i>Cliente
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($empresa->codigo_convite): ?>
                                            <code class="text-primary fw-bold" style="font-size: 0.9rem; cursor: pointer;" 
                                                  onclick="copyToClipboard('<?php echo e($empresa->codigo_convite); ?>')" 
                                                  title="Clique para copiar">
                                                <?php echo e($empresa->codigo_convite); ?>

                                            </code>
                                            <i class="ph ph-copy text-muted ms-1" style="font-size: 0.8rem;"></i>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($empresa->email); ?></td>
                                    <td><?php echo e($empresa->phone); ?></td>
                                    <td class="text-center">
                                        <?php if($empresa->logomarca): ?>
                                            <a href="#" class="preview-media me-2" data-bs-toggle="modal" data-bs-target="#mediaPreviewModal" data-path="<?php echo e(Storage::url($empresa->logomarca)); ?>" data-type="image" title="Preview Logomarca">
                                                <i class="ph-duotone ph-eye"></i>
                                            </a>
                                        <?php endif; ?>
                                        <a href="#" class="toggle-status me-2" data-id="<?php echo e($empresa->id); ?>" title="Mudar Status">
                                            <?php if($empresa->status == 0): ?>
                                                <i class="ph-bold ph-toggle-right text-success"></i>
                                            <?php else: ?>
                                                <i class="ph-bold ph-toggle-left"></i>
                                            <?php endif; ?>
                                        </a>
                                        <a href="#" class="delete-empresa" data-id="<?php echo e($empresa->id); ?>" title="Excluir">
                                            <i class="ph-duotone ph-trash"></i>
                                        </a>
                                        <form id="delete-form-<?php echo e($empresa->id); ?>" action="<?php echo e(route('empresas.destroy', $empresa)); ?>" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                        <form id="toggle-status-form-<?php echo e($empresa->id); ?>" action="<?php echo e(route('empresas.toggleStatus', $empresa)); ?>" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">Nenhuma empresa encontrada.</td>
                                </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php if($empresas->hasPages()): ?>
                        <div class="card-footer">
                            <?php echo e($empresas->appends(request()->query())->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- tables-end  -->
    </div>

    <!-- Trash Modal -->
    <div class="modal fade" id="trashModalEmpresas" tabindex="-1" aria-labelledby="trashModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="trashModalLabel">Empresas Excluídas</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="trashModalBodyEmpresas">
                    <p>Carregando...</p>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Função para copiar código de convite
    function copyToClipboard(text) {
        // Função para mostrar tooltip de sucesso
        function showTooltip(clientX, clientY) {
            const tooltip = document.createElement('div');
            tooltip.textContent = '✓ Copiado!';
            tooltip.style.position = 'fixed';
            tooltip.style.top = clientY + 'px';
            tooltip.style.left = clientX + 'px';
            tooltip.style.backgroundColor = '#198754';
            tooltip.style.color = 'white';
            tooltip.style.padding = '5px 10px';
            tooltip.style.borderRadius = '4px';
            tooltip.style.fontSize = '12px';
            tooltip.style.zIndex = '9999';
            document.body.appendChild(tooltip);

            setTimeout(() => {
                tooltip.remove();
            }, 1500);
        }

        // Tentar usar clipboard API se disponível (HTTPS)
        if (navigator.clipboard && navigator.clipboard.writeText) {
            navigator.clipboard.writeText(text).then(function() {
                showTooltip(event.clientX, event.clientY);
            }).catch(function(err) {
                console.error('Erro ao copiar com clipboard API: ', err);
                fallbackCopy(text);
            });
        } else {
            // Fallback para HTTP usando método tradicional
            fallbackCopy(text);
        }

        function fallbackCopy(text) {
            const textArea = document.createElement('textarea');
            textArea.value = text;
            textArea.style.position = 'fixed';
            textArea.style.top = '0';
            textArea.style.left = '0';
            textArea.style.width = '2em';
            textArea.style.height = '2em';
            textArea.style.padding = '0';
            textArea.style.border = 'none';
            textArea.style.outline = 'none';
            textArea.style.boxShadow = 'none';
            textArea.style.background = 'transparent';
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();

            try {
                const successful = document.execCommand('copy');
                if (successful) {
                    showTooltip(event.clientX, event.clientY);
                } else {
                    alert('Não foi possível copiar. Por favor, copie manualmente: ' + text);
                }
            } catch (err) {
                console.error('Erro ao copiar: ', err);
                alert('Não foi possível copiar. Por favor, copie manualmente: ' + text);
            }

            document.body.removeChild(textArea);
        }
    }
    
    document.addEventListener('DOMContentLoaded', function () {
        // Main page actions
        document.body.addEventListener('click', function(event) {
            if (event.target.closest('.delete-empresa')) {
                event.preventDefault();
                let empresaId = event.target.closest('.delete-empresa').dataset.id;
                if (confirm('Tem certeza que deseja enviar esta empresa para a lixeira?')) {
                    document.getElementById('delete-form-' + empresaId).submit();
                }
            }
            if (event.target.closest('.toggle-status')) {
                event.preventDefault();
                let empresaId = event.target.closest('.toggle-status').dataset.id;
                document.getElementById('toggle-status-form-' + empresaId).submit();
            }
        });

        // Trash Modal for Empresas
        const trashModalEmpresas = document.getElementById('trashModalEmpresas');
        if(trashModalEmpresas) {
            trashModalEmpresas.addEventListener('show.bs.modal', function () {
                const modalBody = document.getElementById('trashModalBodyEmpresas');
                modalBody.innerHTML = '<p>Carregando...</p>';

                fetch('<?php echo e(route("empresas.trash")); ?>')
                    .then(response => response.json())
                    .then(data => {
                        if (data.length === 0) {
                            modalBody.innerHTML = '<p>A lixeira está vazia.</p>';
                            return;
                        }

                        let tableHtml = '<div class="table-responsive"><table class="table align-middle"><thead><tr><th>Empresa</th><th>Excluído em</th><th>Excluído por</th><th>Ações</th></tr></thead><tbody>';
                        data.forEach(empresa => {
                            const deletedAt = new Date(empresa.deleted_at).toLocaleString('pt-BR');
                            const destroyerName = empresa.destroyer ? empresa.destroyer.name : 'Usuário desconhecido';

                            tableHtml += `
                                <tr>
                                    <td>${empresa.name}</td>
                                    <td>${deletedAt}</td>
                                    <td>${destroyerName}</td>
                                    <td>
                                        <button class="btn btn-sm btn-success restore-empresa" data-id="${empresa.id}">Restaurar</button>
                                        <form id="restore-form-${empresa.id}" action="/empresas/${empresa.id}/restore" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                        </form>
                                    </td>
                                </tr>
                            `;
                        });
                        tableHtml += '</tbody></table></div>';
                        modalBody.innerHTML = tableHtml;
                    })
                    .catch(error => {
                        modalBody.innerHTML = '<p>Ocorreu um erro ao carregar os itens.</p>';
                        console.error('Error fetching trash:', error);
                    });
            });

            trashModalEmpresas.addEventListener('click', function(event) {
                const restoreBtn = event.target.closest('.restore-empresa');
                if (restoreBtn) {
                    event.preventDefault();
                    let empresaId = restoreBtn.dataset.id;
                    if (confirm('Tem certeza que deseja restaurar esta empresa?')) {
                        document.getElementById('restore-form-' + empresaId).submit();
                    }
                }
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/resources/views/empresas/index.blade.php ENDPATH**/ ?>