<!-- Menu Navigation starts -->
<nav>
    <div class="app-logo">
        <a class="logo d-inline-block" href="<?php echo e(route('dashboard')); ?>">
            <img alt="#" src="<?php echo e(asset('assets/images/logo/1.png')); ?>">
        </a>

        <span class="bg-light-primary toggle-semi-nav d-flex-center">
                <i class="ti ti-chevron-right"></i>
            </span>

        <div class="d-flex align-items-center nav-profile p-3">
                <span class="h-45 w-45 d-flex-center b-r-10 position-relative bg-danger m-auto">
                    <img alt="avatar" class="img-fluid b-r-10" src="<?php echo e(asset('assets/images/avatar/' . (Auth::user()->avatar ?? '1.png'))); ?>">
                    <span class="position-absolute top-0 end-0 p-1 bg-success border border-light rounded-circle"></span>
                </span>
            <div class="flex-grow-1 ps-2">
                <h6 class="text-primary mb-0"> <?php echo e(Auth::user()->name); ?></h6>
            </div>


            <div class="dropdown profile-menu-dropdown">
                <a aria-expanded="false" data-bs-auto-close="true" data-bs-placement="top" data-bs-toggle="dropdown"
                   role="button">
                    <i class="ti ti-settings fs-5"></i>
                </a>
                <ul class="dropdown-menu">
                    <li class="dropdown-item">
                        <a class="f-w-500" href="<?php echo e(route('profile.edit')); ?>">
                            <i class="ph-duotone  ph-user-circle pe-1 f-s-20"></i> <?php echo e(__('Profile')); ?>

                        </a>
                    </li>
                    <li class="dropdown-item">
                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>

                            <a class="mb-0 text-danger" href="<?php echo e(route('logout')); ?>"
                                    onclick="event.preventDefault();
                                                this.closest('form').submit();">
                                <i class="ph-duotone  ph-sign-out pe-1 f-s-20"></i> <?php echo e(__('Log Out')); ?>

                            </a>
                        </form>
                    </li>
                </ul>
            </div>

        </div>
    </div>
    <div class="app-nav" id="app-simple-bar">
        <ul class="main-nav p-0 mt-2">
            <li>
                <a href="<?php echo e(route('dashboard')); ?>">
                    <svg stroke="currentColor" stroke-width="1.5">
                        <use xlink:href="<?php echo e(asset('assets/svg/_sprite.svg#home')); ?>"></use>
                    </svg>
                    <span><?php echo e(__('Dashboard')); ?></span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('users.index')); ?>">
                    <i class="ph-duotone ph-users f-s-20"></i>
                    <span><?php echo e(__('Users')); ?></span>
                </a>
            </li>
            <li>
                <a aria-expanded="false" data-bs-toggle="collapse" href="#franchise">
                    <i class="ph-duotone ph-buildings f-s-20"></i>
                    Empresas
                </a>
                <ul class="collapse" id="franchise">
                    <li><a href="<?php echo e(route('empresas.index')); ?>">Todas as Empresas</a></li>
                    <li><a href="<?php echo e(route('empresas.index', ['tipo' => 'franquia'])); ?>">Franquias</a></li>
                    <li><a href="<?php echo e(route('empresas.index', ['tipo' => 'cliente'])); ?>">Clientes</a></li>
                </ul>
            </li>
            <li>
                <a href="<?php echo e(route('hotspots.index')); ?>">
                    <i class="ph-duotone ph-wifi-high f-s-20"></i>
                    <span>Hotspots</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('midias.index')); ?>">
                    <i class="ph-duotone ph-image f-s-20"></i>
                    <span>Criativos</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('publicacoes.index')); ?>">
                    <i class="ph-duotone ph-broadcast f-s-20"></i>
                    <span><?php echo e(__('Publications')); ?></span>
                </a>
            </li>
            
        </ul>
    </div>

    <div class="menu-navs">
        <span class="menu-previous"><i class="ti ti-chevron-left"></i></span>
        <span class="menu-next"><i class="ti ti-chevron-right"></i></span>
    </div>

</nav>
<!-- Menu Navigation ends -->
<?php /**PATH /var/www/html/resources/views/layouts/sidebar.blade.php ENDPATH**/ ?>