<?php $__env->startSection('content'); ?>
<style>
    .form-control {
        color: #000 !important;
    }
    .hidden { display: none; }
    .step-indicator {
        background: rgba(255,255,255,0.1);
        padding: 1rem;
        border-radius: 0.5rem;
        margin-bottom: 1.5rem;
    }
</style>

<div class="form-container">
    <form class="app-form" method="POST" action="<?php echo e(route('register')); ?>" id="registerForm">
        <?php echo csrf_field(); ?>
        
        <div class="row">
            <div class="col-12">
                <div class="mb-4 text-center text-lg-start">
                    <h2 class="text-white f-w-600"><?php echo e(__('Cadastro com Código de Convite')); ?></h2>
                    <p class="text-white-50"><?php echo e(__('Use o código fornecido pela franquia')); ?></p>
                </div>
            </div>

            <?php if(session('success')): ?>
                <div class="col-12">
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                </div>
            <?php endif; ?>

            <?php if($errors->has('error')): ?>
                <div class="col-12">
                    <div class="alert alert-danger">
                        <?php echo e($errors->first('error')); ?>

                    </div>
                </div>
            <?php endif; ?>

            
            <div id="step1" class="col-12">
                <div class="step-indicator">
                    <small class="text-white-50">Passo 1 de 2</small>
                </div>

                <div class="form-floating mb-3">
                    <input 
                        class="form-control text-uppercase" 
                        id="codigo_convite" 
                        placeholder="XXXX999999" 
                        type="text" 
                        name="codigo_convite" 
                        value="<?php echo e(old('codigo_convite')); ?>" 
                        maxlength="10"
                        required 
                        autocomplete="off"
                        style="text-transform: uppercase;"
                    >
                    <label for="codigo_convite"><?php echo e(__('Código de Convite')); ?></label>
                    <?php $__errorArgs = ['codigo_convite'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <small class="text-white-50"><?php echo e(__('10 caracteres (ex: ABCD123456)')); ?></small>
                </div>

                <div class="mb-3">
                    <button 
                        type="button" 
                        id="validateCodeBtn"
                        class="btn btn-primary w-100"
                    >
                        <span id="validateBtnText"><?php echo e(__('Validar Código')); ?></span>
                        <span id="validateBtnLoading" class="hidden">
                            <span class="spinner-border spinner-border-sm me-2"></span>
                            <?php echo e(__('Validando...')); ?>

                        </span>
                    </button>
                </div>

                
                <div id="empresaInfo" class="hidden alert alert-success">
                    <strong>✅ Franquia:</strong> <span id="empresaName"></span>
                    <input type="hidden" name="empresa_id" id="empresa_id">
                </div>

                <div id="codeErrorMsg" class="hidden alert alert-danger">
                    <strong>❌ Erro:</strong> <span id="codeErrorText"></span>
                </div>
            </div>

            
            <div id="step2" class="hidden col-12">
                <div class="step-indicator">
                    <small class="text-white-50">Passo 2 de 2 - Seus Dados</small>
                </div>

                <div class="form-floating mb-3">
                    <input 
                        class="form-control" 
                        id="name" 
                        placeholder="Nome Completo" 
                        type="text" 
                        name="name" 
                        value="<?php echo e(old('name')); ?>" 
                        required
                    >
                    <label for="name"><?php echo e(__('Nome Completo')); ?></label>
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-floating mb-3">
                    <input 
                        class="form-control" 
                        id="email" 
                        placeholder="Email" 
                        type="email" 
                        name="email" 
                        value="<?php echo e(old('email')); ?>" 
                        required
                    >
                    <label for="email"><?php echo e(__('Email')); ?></label>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-floating mb-3">
                    <input 
                        class="form-control" 
                        id="phone" 
                        placeholder="Telefone" 
                        type="text" 
                        name="phone" 
                        value="<?php echo e(old('phone')); ?>"
                    >
                    <label for="phone"><?php echo e(__('Telefone (opcional)')); ?></label>
                </div>

                <div class="form-floating mb-3">
                    <input 
                        class="form-control" 
                        id="password" 
                        placeholder="Senha" 
                        type="password" 
                        name="password" 
                        required
                    >
                    <label for="password"><?php echo e(__('Senha')); ?></label>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <small class="text-white-50"><?php echo e(__('Mínimo de 8 caracteres')); ?></small>
                </div>

                <div class="form-floating mb-3">
                    <input 
                        class="form-control" 
                        id="password_confirmation" 
                        placeholder="Confirmar Senha" 
                        type="password" 
                        name="password_confirmation" 
                        required
                    >
                    <label for="password_confirmation"><?php echo e(__('Confirmar Senha')); ?></label>
                </div>

                <div class="row">
                    <div class="col-6">
                        <button type="button" id="backBtn" class="btn btn-secondary w-100">
                            <?php echo e(__('Voltar')); ?>

                        </button>
                    </div>
                    <div class="col-6">
                        <button type="submit" class="btn btn-primary w-100">
                            <?php echo e(__('Finalizar Cadastro')); ?>

                        </button>
                    </div>
                </div>
            </div>

            <div class="col-12 mt-4">
                <div class="text-center text-lg-start">
                    <?php echo e(__('Já tem uma conta?')); ?> 
                    <a class="text-white text-decoration-underline" href="<?php echo e(route('login')); ?>">
                        <?php echo e(__('Fazer login')); ?>

                    </a>
                </div>
            </div>
        </div>
    </form>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const codigoInput = document.getElementById('codigo_convite');
    const validateBtn = document.getElementById('validateCodeBtn');
    const validateBtnText = document.getElementById('validateBtnText');
    const validateBtnLoading = document.getElementById('validateBtnLoading');
    const empresaInfo = document.getElementById('empresaInfo');
    const empresaName = document.getElementById('empresaName');
    const empresaIdInput = document.getElementById('empresa_id');
    const step1 = document.getElementById('step1');
    const step2 = document.getElementById('step2');
    const backBtn = document.getElementById('backBtn');
    const codeErrorMsg = document.getElementById('codeErrorMsg');
    const codeErrorText = document.getElementById('codeErrorText');

    // Maiúsculo
    codigoInput.addEventListener('input', function() {
        this.value = this.value.toUpperCase();
    });

    // Validar código
    validateBtn.addEventListener('click', async function() {
        const codigo = codigoInput.value.trim();
        
        if (codigo.length !== 10) {
            codeErrorText.textContent = 'O código deve ter exatamente 10 caracteres';
            codeErrorMsg.classList.remove('hidden');
            return;
        }

        validateBtn.disabled = true;
        validateBtnText.classList.add('hidden');
        validateBtnLoading.classList.remove('hidden');
        codeErrorMsg.classList.add('hidden');

        try {
            const response = await fetch('<?php echo e(route("register.validate-code")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ codigo })
            });

            const data = await response.json();

            if (response.ok && data.valid) {
                empresaIdInput.value = data.empresa.id;
                empresaName.textContent = data.empresa.name;
                empresaInfo.classList.remove('hidden');
                step2.classList.remove('hidden');
                document.getElementById('name').focus();
            } else {
                codeErrorText.textContent = data.message || 'Código inválido';
                codeErrorMsg.classList.remove('hidden');
            }
        } catch (error) {
            codeErrorText.textContent = 'Erro ao validar. Tente novamente.';
            codeErrorMsg.classList.remove('hidden');
        } finally {
            validateBtn.disabled = false;
            validateBtnText.classList.remove('hidden');
            validateBtnLoading.classList.add('hidden');
        }
    });

    backBtn.addEventListener('click', function() {
        step2.classList.add('hidden');
        empresaInfo.classList.add('hidden');
    });

    // Se houver erros, mostrar step2
    <?php if($errors->any() && old('name')): ?>
        step2.classList.remove('hidden');
    <?php endif; ?>
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/resources/views/auth/register.blade.php ENDPATH**/ ?>