<?php

use App\Models\Midia;
use App\Models\Empresa;
use App\Models\User;

test('shows correct row numbering in midias table', function () {
    $user = User::factory()->create();
    $this->actingAs($user);
    
    $empresa = Empresa::factory()->create();
    
    // Criar 3 mídias
    Midia::factory()->count(3)->create(['empresa_id' => $empresa->id]);
    
    $response = $this->get(route('midias.index'));
    
    $response->assertStatus(200);
    
    // Verificar se a coluna # existe
    $response->assertSee('<th scope="col" class="text-center" width="50">#</th>', false);
    
    // Verificar se os números aparecem (1, 2, 3)
    for ($i = 1; $i <= 3; $i++) {
        $response->assertSee('<td class="text-center">' . $i . '</td>', false);
    }
});

test('midias row numbering works across pages', function () {
    $user = User::factory()->create();
    $this->actingAs($user);
    
    $empresa = Empresa::factory()->create();
    
    // Criar 20 mídias (mais que uma página)
    Midia::factory()->count(20)->create(['empresa_id' => $empresa->id]);
    
    // Acessar a segunda página (assumindo 15 por página)
    $response = $this->get(route('midias.index', ['page' => 2]));
    
    $response->assertStatus(200);
    
    // Na segunda página, a numeração deve começar em 16
    $response->assertSee('<td class="text-center">16</td>', false);
});