# 📚 Índice de Testes e Documentação

> **Pasta Padrão:** `tests/`  
> **Organização:** Todos os testes e documentação do projeto ficam centralizados aqui

## 📁 Estrutura

```
tests/
├── frontend-tests/          # Testes de interface
│   └── test-modal-preview.html
├── documentation/           # Documentação técnica
│   ├── 00-INDICE-TESTES.md (este arquivo)
│   └── [demais arquivos .md e .txt]
├── Feature/                 # Testes funcionais (Laravel)
├── Unit/                    # Testes unitários (Laravel)
└── Pest.php                 # Configuração Pest
```

---

## 🧪 Testes Frontend

### test-modal-preview.html
- **Descrição:** Teste standalone do modal de preview de imagens
- **Localização:** `tests/frontend-tests/test-modal-preview.html`
- **Como usar:** Abrir diretamente no navegador
- **Objetivo:** Validar responsividade do modal sem Laravel

---

## 📖 Documentação por Categoria

### 🎯 Sistema de Publicações e Mídias
- `SOLUCAO-MODAL-PREVIEW.md` - Modal de preview responsivo
- `SOLUCAO-PREVIEW-IMAGENS.md` - Preview de imagens
- `PROBLEMA-UPLOAD-CRIATIVOS.md` - Problema de upload
- `LOCALIZACAO-FISICA-IMAGENS.md` - Onde ficam as imagens
- `TESTE-UPLOAD-COMPLETO.md` - Testes de upload
- `RESUMO-SISTEMA-MIDIAS-COMPLETO.md` - Resumo completo
- `SOLUCAO-MIDIAS-CRIATIVOS.md` - Solução de mídias
- `FLUXO-CRIATIVOS-PUBLICACOES.md` - Fluxo completo
- `API-PUBLICACOES-LOGICA.md` - Lógica da API

### 🏢 Sistema de Empresas e Convites
- `CODIGO-CONVITE-EMPRESAS.md` - Sistema de convites
- `CODIGO-CONVITE-RESUMO.md` - Resumo do sistema
- `CODIGO-CONVITE-FORMATO-FINAL.md` - Formato final

### 👥 Sistema de Usuários e Perfis
- `RELATORIO-TESTES-PERFIL.md` - Testes de perfil
- `RELATORIO_ATUALIZACAO_USERS_VIEW.md` - Atualização de views
- `AVATAR-DINAMICO.md` - Avatar dinâmico
- `TIPO-ALCANCE-EXPLICACAO.md` - Tipo de alcance

### 🔐 Autenticação e Permissões
- `FLUXO-AUTENTICACAO.md` - Fluxo de autenticação
- `ANALISE-GROUPS-PERMISSIONS.md` - Análise de permissões

### 📧 Sistema de E-mails
- `SISTEMA-EMAILS.md` - Sistema completo
- `TESTES-EMAIL.md` - Testes de e-mail
- `FEATURE-FLAGS-EMAILS.md` - Feature flags

### 🚩 Feature Flags
- `FEATURE-FLAGS-RESUMO.md` - Resumo geral
- `FEATURE-FLAGS-GUIA-RAPIDO.md` - Guia rápido

### 🔍 Filtros e Pesquisa
- `RELATORIO_BOTAO_LIMPAR_FILTROS.md` - Botão limpar
- `GUIA_RAPIDO_FILTROS.md` - Guia rápido
- `TESTES_FILTRO.md` - Testes de filtro
- `RESUMO_FILTRO_IMPLEMENTACAO.md` - Implementação
- `FILTRO_AVANCADO.md` - Filtro avançado
- `README_FILTRO_AVANCADO.md` - README filtro

### 📍 Hotspots
- `ULTIMA_ATIVIDADE_HOTSPOTS.md` - Última atividade
- `LEGENDA_STATUS_HOTSPOTS.md` - Legenda de status
- `SOLUCAO-HOTSPOT-NULL-ERROR.md` - Solução de erro
- `HOTSPOTS_MODULE_SUMMARY.md` - Resumo do módulo
- `RESUMO_STATUS_VISUAL.md` - Status visual

### 🧪 Testes e Relatórios
- `RELATORIO_TESTES_REGISTRO.md` - Testes de registro
- `SUMARIO_REGISTRO.md` - Sumário de registro
- `RELATORIO_BUGS_HTTP_E2E.md` - Bugs HTTP E2E
- `RELATORIO_ROTAS.md` - Relatório de rotas
- `RELATORIO_E2E.md` - Testes E2E
- `GUIA_TESTES_PRATICOS.md` - Guia prático
- `FASE1_TESTES_COMPLETOS.md` - Testes fase 1

### 🏗️ Estrutura e Arquitetura
- `ESTRUTURA_ARQUIVOS.md` - Estrutura de arquivos
- `INDICE_DOCUMENTACAO.md` - Índice de documentação
- `FASE1_ESTRUTURA_COMPLETA.md` - Fase 1 completa
- `FASE2_CADASTRO_E_APROVACAO.md` - Fase 2
- `ROADMAP.md` - Roadmap do projeto

### 🔧 Soluções e Correções
- `RESUMO-COMPLETO-CORRECOES-17-10-2025.md` - Correções 17/10
- `SOLUCAO-VIEW-NOT-FOUND.md` - View not found
- `RELATORIO-FINAL-AUDITORIA.md` - Auditoria final
- `AUDITORIA-VIEWS-PROBLEMAS.md` - Problemas de views
- `VERIFICACAO-FINAL.md` - Verificação final

### 📝 Sumários Executivos
- `SUMARIO_EXECUTIVO.md` - Sumário executivo
- `RESUMO_FASE1.md` - Resumo fase 1
- `README_IMPLEMENTACAO.md` - README implementação

### 📄 Textos Diversos
- `resumo.txt` - Resumo textual
- `readme.txt` - README textual

---

## 🎯 Convenções

1. **Nomenclatura:**
   - Testes HTML: `test-*.html`
   - Documentação: `*.md`
   - Resumos: `RESUMO-*.md`
   - Relatórios: `RELATORIO-*.md`
   - Soluções: `SOLUCAO-*.md`

2. **Localização:**
   - Testes frontend: `tests/frontend-tests/`
   - Documentação: `tests/documentation/`
   - Testes backend: `tests/Feature/` e `tests/Unit/`

3. **Atualização:**
   - Manter este índice atualizado
   - Data no nome do arquivo quando relevante
   - Categorizar por área/módulo

---

**Última atualização:** 18/10/2025  
**Total de documentos:** 57 arquivos
