# 🚀 GUIA DE DEPLOY MANUAL - PAGINAÇÃO

## ✅ Status Atual
- ✅ Código commitado localmente (SHA: 673b26f)
- ✅ Push feito para GitHub (branch: main)
- ✅ Servidor acessível: http://172.233.21.57:8082
- ⏳ **Aguardando execução dos comandos no servidor**

---

## 📋 COMANDOS PARA EXECUTAR NO SERVIDOR

### **Opção 1: Via SSH (Recomendado)**

```bash
# 1. Conectar ao servidor
ssh root@172.233.21.57

# 2. Navegar para o diretório
cd /var/www/html/laravel/admin/freefi_admin

# 3. Fazer backup (segurança)
mkdir -p backups/deploy-$(date +%Y%m%d_%H%M%S)
cp app/Providers/AppServiceProvider.php backups/deploy-$(date +%Y%m%d_%H%M%S)/
cp resources/views/publicacoes/index.blade.php backups/deploy-$(date +%Y%m%d_%H%M%S)/

# 4. Atualizar código do GitHub
git fetch --all
git pull origin main

# 5. Verificar se correção foi baixada
grep "Paginator::useBootstrapFive()" app/Providers/AppServiceProvider.php

# 6. Limpar caches
php8.3 artisan config:clear
php8.3 artisan view:clear
php8.3 artisan cache:clear

# 7. Otimizar para produção
php8.3 artisan config:cache
php8.3 artisan view:cache

# 8. Reiniciar serviço
docker-compose restart app

# 9. Verificar logs
docker-compose logs -f app --tail=50
```

---

### **Opção 2: Comandos em Uma Linha (Copiar e Colar)**

```bash
ssh root@172.233.21.57 << 'ENDSSH'
cd /var/www/html/laravel/admin/freefi_admin && \
git pull origin main && \
php8.3 artisan config:clear && \
php8.3 artisan view:clear && \
php8.3 artisan cache:clear && \
php8.3 artisan config:cache && \
php8.3 artisan view:cache && \
docker-compose restart app && \
echo "✅ Deploy concluído!"
ENDSSH
```

---

### **Opção 3: Usando o Script Automatizado**

```bash
# 1. Copiar script para servidor
scp /tmp/deploy_commands.txt root@172.233.21.57:/tmp/

# 2. Executar no servidor
ssh root@172.233.21.57 'bash /tmp/deploy_commands.txt'
```

---

### **Opção 4: Via Painel/Terminal do Servidor**

Se você tem acesso via painel web (Portainer, cPanel, etc):

```bash
cd /var/www/html/laravel/admin/freefi_admin
git pull origin main
php8.3 artisan config:clear && php8.3 artisan view:clear && php8.3 artisan cache:clear
php8.3 artisan config:cache && php8.3 artisan view:cache
docker-compose restart app
```

---

## 🔍 VERIFICAÇÃO PÓS-DEPLOY

### **1. Verificar se código foi atualizado**

```bash
ssh root@172.233.21.57
cd /var/www/html/laravel/admin/freefi_admin

# Ver último commit
git log -1 --oneline

# Deve mostrar:
# 673b26f fix: Corrige paginação Bootstrap 5 nas publicações

# Verificar arquivos
grep "Paginator::useBootstrapFive()" app/Providers/AppServiceProvider.php
grep "firstItem" resources/views/publicacoes/index.blade.php
```

### **2. Verificar serviços**

```bash
# Ver status dos containers
docker-compose ps

# Ver logs
docker-compose logs app --tail=100

# Verificar se aplicação está respondendo
curl -I http://172.233.21.57:8082
```

### **3. Teste Manual (Navegador)**

1. Abrir: http://172.233.21.57:8082/login
2. Login: `linuxewireless@gmail.com` / `password`
3. Acessar: `/publicacoes`
4. Verificar rodapé da tabela:
   - ✅ Deve mostrar: "Mostrando X a Y de Z publicações"
   - ✅ Se houver >15 publicações: Botões Bootstrap 5 visíveis

### **4. Inspeção Visual (DevTools - F12)**

```javascript
// No console do navegador
document.querySelector('.pagination')

// Deve retornar um elemento <ul> com classes Bootstrap 5
// Não deve ter comentário: "populated via JavaScript"
```

### **5. Teste Automatizado (Local)**

```bash
# Executar de sua máquina local
php8.3 artisan dusk tests/Browser/ProducaoPaginacaoTest.php --filter=testVerificarCorrecaoAplicada
```

---

## ⚠️ TROUBLESHOOTING

### **Problema: git pull falha**

```bash
# Ver status
git status

# Se houver conflitos, resetar
git fetch --all
git reset --hard origin/main
git pull origin main
```

### **Problema: Cache não limpa**

```bash
# Limpar manualmente
rm -rf bootstrap/cache/*.php
rm -rf storage/framework/cache/*
rm -rf storage/framework/views/*

# Depois rodar os comandos artisan
php8.3 artisan config:cache
php8.3 artisan view:cache
```

### **Problema: Docker não reinicia**

```bash
# Parar e iniciar
docker-compose down
docker-compose up -d

# Ou rebuild
docker-compose down
docker-compose up -d --build
```

### **Problema: Paginação ainda vazia**

```bash
# 1. Verificar se correção foi aplicada
grep "Paginator::useBootstrapFive()" app/Providers/AppServiceProvider.php

# 2. Se não encontrar, editar manualmente
nano app/Providers/AppServiceProvider.php

# Adicionar:
# use Illuminate\Pagination\Paginator;
# No método boot(): Paginator::useBootstrapFive();

# 3. Limpar cache novamente
php8.3 artisan config:clear && php8.3 artisan config:cache
docker-compose restart app
```

---

## 📊 RESULTADO ESPERADO

### **Antes do Deploy:**
```html
<ul class="pagination pagination-sm mb-0" id="visualizacoesPagination">
    <!-- Pagination buttons will be populated via JavaScript -->
</ul>
```

### **Depois do Deploy:**
```html
<div class="d-flex justify-content-between align-items-center mt-4">
    <div class="text-muted small">
        Mostrando 1 a 4 de 4 publicações
    </div>
</div>
```

Ou se houver >15 publicações:

```html
<div class="d-flex justify-content-between align-items-center mt-4">
    <div class="text-muted small">
        Mostrando 1 a 15 de 23 publicações
    </div>
    <div>
        <ul class="pagination">
            <li class="page-item disabled">
                <span class="page-link">‹</span>
            </li>
            <li class="page-item active">
                <span class="page-link">1</span>
            </li>
            <li class="page-item">
                <a class="page-link" href="?page=2">2</a>
            </li>
            <li class="page-item">
                <a class="page-link" href="?page=2">›</a>
            </li>
        </ul>
    </div>
</div>
```

---

## 📞 SUPORTE

### **Logs para Análise:**
```bash
# Logs da aplicação
tail -f storage/logs/laravel.log

# Logs do Docker
docker-compose logs -f app

# Logs do Nginx
docker-compose logs -f nginx
```

### **Arquivos Importantes:**
- `app/Providers/AppServiceProvider.php` - Configuração Bootstrap 5
- `resources/views/publicacoes/index.blade.php` - View da paginação
- `CORRECAO_PAGINACAO.md` - Documentação completa

---

## ✅ CHECKLIST FINAL

- [ ] SSH no servidor: `ssh root@172.233.21.57`
- [ ] Navegar: `cd /var/www/html/laravel/admin/freefi_admin`
- [ ] Backup criado
- [ ] `git pull origin main` executado
- [ ] Correção verificada: `grep "Paginator::useBootstrapFive()"`
- [ ] Cache limpo: `php8.3 artisan config:clear view:clear cache:clear`
- [ ] Cache otimizado: `php8.3 artisan config:cache view:cache`
- [ ] Container reiniciado: `docker-compose restart app`
- [ ] Teste manual: http://172.233.21.57:8082/publicacoes
- [ ] Paginação funcionando corretamente

---

**Após executar os comandos, a paginação Bootstrap 5 estará funcionando corretamente! 🎉**

---

**Criado por:** Claude Code
**Data:** 03/11/2025
**Commit:** 673b26f
