# 🎛️ Feature Flags - Controle de Emails

Sistema de controle granular para habilitar/desabilitar envio de emails no FreeFi Admin.

---

## 📋 Configuração (.env)

```env
# Flag Mestre - Desabilita TODOS os emails
FEATURE_EMAIL_ENABLED=true

# Controle Individual por Tipo
FEATURE_EMAIL_CADASTRO_APROVADO=true
FEATURE_EMAIL_CADASTRO_REJEITADO=true
FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE=true

# Modo Desenvolvimento (opcional)
FEATURE_EMAIL_DEV_MODE=false

# Email de Teste (opcional)
FEATURE_EMAIL_TEST_RECIPIENT=null
```

---

## 🎯 Como Funciona

### 1. **Flag Mestre (`FEATURE_EMAIL_ENABLED`)**

**Controle global de todos os emails**

```env
FEATURE_EMAIL_ENABLED=false  # ❌ Desabilita TODOS os emails
FEATURE_EMAIL_ENABLED=true   # ✅ Habilita (respeita flags individuais)
```

**Quando usar:**
- Manutenção do servidor SMTP
- Troubleshooting geral
- Desabilitar temporariamente todos os emails

---

### 2. **Flags Individuais**

**Controle específico por tipo de email**

#### Email de Cadastro Aprovado
```env
FEATURE_EMAIL_CADASTRO_APROVADO=false  # Desabilita apenas este tipo
```
- Envia quando: Admin aprova um cadastro
- Destinatário: Usuário aprovado
- Template: Verde com checkmark ✅

#### Email de Cadastro Rejeitado
```env
FEATURE_EMAIL_CADASTRO_REJEITADO=false  # Desabilita apenas este tipo
```
- Envia quando: Admin rejeita um cadastro
- Destinatário: Usuário rejeitado
- Template: Vermelho com X ❌

#### Email de Novo Cadastro Pendente
```env
FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE=false  # Desabilita apenas este tipo
```
- Envia quando: Novo usuário se cadastra
- Destinatário: Todos os administradores
- Template: Laranja com sino 🔔

---

### 3. **Modo Desenvolvimento (`FEATURE_EMAIL_DEV_MODE`)**

**Apenas loga, não envia emails reais**

```env
FEATURE_EMAIL_DEV_MODE=true  # Modo desenvolvimento
FEATURE_EMAIL_DEV_MODE=false # Modo produção (padrão)
```

**No modo desenvolvimento:**
- ✅ Emails são logados em `storage/logs/laravel.log`
- ❌ Nenhum email é enviado de verdade
- ✅ Não consome quota de SMTP
- ✅ Ideal para desenvolvimento/testes

**Exemplo de log:**
```
[2025-10-17 15:30:45] local.INFO: Email de aprovação (dev mode)
{
    "tipo": "CadastroAprovado",
    "destinatario": "usuario@example.com",
    "usuario": "João Silva"
}
```

---

### 4. **Email de Teste (`FEATURE_EMAIL_TEST_RECIPIENT`)**

**Redireciona TODOS os emails para um único endereço**

```env
FEATURE_EMAIL_TEST_RECIPIENT=linuxewireless@gmail.com
```

**Quando usar:**
- Testar emails sem enviar para usuários reais
- Validar templates e conteúdo
- Demonstrações para clientes

**Como funciona:**
- Emails que iriam para `usuario@example.com` vão para `linuxewireless@gmail.com`
- Log registra o redirecionamento
- Útil para homologação

---

## 🔄 Cenários de Uso

### Cenário 1: Produção Normal
```env
FEATURE_EMAIL_ENABLED=true
FEATURE_EMAIL_CADASTRO_APROVADO=true
FEATURE_EMAIL_CADASTRO_REJEITADO=true
FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE=true
FEATURE_EMAIL_DEV_MODE=false
FEATURE_EMAIL_TEST_RECIPIENT=null
```
✅ Todos os emails funcionando normalmente

---

### Cenário 2: Desenvolvimento Local
```env
FEATURE_EMAIL_ENABLED=true
FEATURE_EMAIL_CADASTRO_APROVADO=true
FEATURE_EMAIL_CADASTRO_REJEITADO=true
FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE=true
FEATURE_EMAIL_DEV_MODE=true  # ← Apenas loga
FEATURE_EMAIL_TEST_RECIPIENT=null
```
✅ Testa lógica sem enviar emails reais  
📝 Verifica logs em `storage/logs/laravel.log`

---

### Cenário 3: Homologação/Testes
```env
FEATURE_EMAIL_ENABLED=true
FEATURE_EMAIL_CADASTRO_APROVADO=true
FEATURE_EMAIL_CADASTRO_REJEITADO=true
FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE=true
FEATURE_EMAIL_DEV_MODE=false
FEATURE_EMAIL_TEST_RECIPIENT=seu_email_teste@example.com  # ← Redireciona
```
✅ Envia emails reais, mas só para você  
🧪 Valida templates e conteúdo

---

### Cenário 4: Manutenção do SMTP
```env
FEATURE_EMAIL_ENABLED=false  # ← Desabilita tudo
FEATURE_EMAIL_CADASTRO_APROVADO=true
FEATURE_EMAIL_CADASTRO_REJEITADO=true
FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE=true
FEATURE_EMAIL_DEV_MODE=false
FEATURE_EMAIL_TEST_RECIPIENT=null
```
❌ Nenhum email é enviado  
✅ Sistema continua funcionando normalmente

---

### Cenário 5: Desabilitar Apenas Notificações de Admins
```env
FEATURE_EMAIL_ENABLED=true
FEATURE_EMAIL_CADASTRO_APROVADO=true
FEATURE_EMAIL_CADASTRO_REJEITADO=true
FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE=false  # ← Apenas este
FEATURE_EMAIL_DEV_MODE=false
FEATURE_EMAIL_TEST_RECIPIENT=null
```
✅ Usuários recebem emails de aprovação/rejeição  
❌ Admins não são notificados de novos cadastros

---

## 🛠️ Como Usar

### 1. **Desabilitar Todos os Emails (Emergência)**

```bash
# Editar .env
nano .env

# Alterar
FEATURE_EMAIL_ENABLED=false

# Limpar cache
php artisan config:clear
```

### 2. **Habilitar Modo Desenvolvimento**

```bash
# Editar .env
FEATURE_EMAIL_DEV_MODE=true

# Limpar cache
php artisan config:clear

# Acompanhar logs
tail -f storage/logs/laravel.log
```

### 3. **Redirecionar para Email de Teste**

```bash
# Editar .env
FEATURE_EMAIL_TEST_RECIPIENT=seu_email@example.com

# Limpar cache
php artisan config:clear

# Fazer cadastro de teste
# Verificar seu email
```

### 4. **Desabilitar Apenas Um Tipo**

```bash
# Desabilitar notificações para admins
FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE=false

# Limpar cache
php artisan config:clear
```

---

## 📊 Feedback Visual

O sistema mostra mensagens diferentes dependendo da configuração:

### Email Habilitado (Normal)
```
✅ Cadastro de João Silva aprovado com sucesso! Um e-mail de confirmação foi enviado.
```

### Email Desabilitado
```
✅ Cadastro de João Silva aprovado com sucesso! (envio de email desabilitado)
```

### Modo Desenvolvimento
```
✅ Cadastro de João Silva aprovado com sucesso! (email logado em modo desenvolvimento)
```

---

## 🔍 Verificar Status Atual

### Via Tinker:
```php
php artisan tinker

// Verificar flag mestre
>>> config('features.email_enabled')

// Verificar flag específica
>>> config('features.emails.cadastro_aprovado')

// Verificar modo dev
>>> config('features.dev_mode')

// Verificar email de teste
>>> config('features.test_recipient')
```

### Via Logs:
```bash
# Ver logs de desenvolvimento
tail -f storage/logs/laravel.log | grep "dev mode"

# Ver logs de redirecionamento
tail -f storage/logs/laravel.log | grep "redirecionado"
```

---

## 🐛 Troubleshooting

### Problema: Emails não estão sendo enviados

**Solução:**
1. Verificar flags no `.env`:
   ```bash
   cat .env | grep FEATURE_EMAIL
   ```

2. Limpar cache de configuração:
   ```bash
   php artisan config:clear
   php artisan config:cache
   ```

3. Verificar logs:
   ```bash
   tail -n 50 storage/logs/laravel.log
   ```

### Problema: Emails vão para pessoa errada

**Possível causa:** `FEATURE_EMAIL_TEST_RECIPIENT` configurado

**Solução:**
```bash
# Editar .env
FEATURE_EMAIL_TEST_RECIPIENT=null

# Limpar cache
php artisan config:clear
```

### Problema: Modo dev não está funcionando

**Solução:**
```bash
# Verificar se está habilitado
php artisan tinker
>>> config('features.dev_mode')

# Deve retornar: true

# Se retornar false, editar .env
FEATURE_EMAIL_DEV_MODE=true

# Limpar cache
php artisan config:clear
```

---

## 📝 Boas Práticas

### ✅ Recomendações:

1. **Produção:**
   - FEATURE_EMAIL_ENABLED=true
   - FEATURE_EMAIL_DEV_MODE=false
   - FEATURE_EMAIL_TEST_RECIPIENT=null

2. **Desenvolvimento:**
   - FEATURE_EMAIL_ENABLED=true
   - FEATURE_EMAIL_DEV_MODE=true
   - FEATURE_EMAIL_TEST_RECIPIENT=null

3. **Homologação:**
   - FEATURE_EMAIL_ENABLED=true
   - FEATURE_EMAIL_DEV_MODE=false
   - FEATURE_EMAIL_TEST_RECIPIENT=seu_email_qa@example.com

4. **Sempre limpar cache após alterar `.env`:**
   ```bash
   php artisan config:clear
   ```

5. **Nunca commitar `.env`:**
   - Adicionar no `.gitignore`
   - Documentar no `.env.example`

---

## 🎯 Resumo

| Flag | Descrição | Valores | Padrão |
|------|-----------|---------|--------|
| `FEATURE_EMAIL_ENABLED` | Flag mestre (tudo) | true/false | true |
| `FEATURE_EMAIL_CADASTRO_APROVADO` | Email de aprovação | true/false | true |
| `FEATURE_EMAIL_CADASTRO_REJEITADO` | Email de rejeição | true/false | true |
| `FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE` | Notificação admins | true/false | true |
| `FEATURE_EMAIL_DEV_MODE` | Apenas loga | true/false | false |
| `FEATURE_EMAIL_TEST_RECIPIENT` | Redirecionar para | email ou null | null |

---

**Última atualização:** 17/10/2025  
**Versão:** 1.0  
**Status:** ✅ Implementado e Documentado
