# 🚀 Workflow de Deploy - FreeFi Admin

## 📊 Configuração Atual

### **Pipelines GitHub Actions**

| Pipeline | Status | Trigger | Função |
|----------|--------|---------|--------|
| **CI** (ci.yml) | ✅ **Ativa** | Pull Requests | Roda testes automaticamente |
| **Deploy** (deploy.yml) | ❌ Desabilitada | - | Antiga pipeline Docker (não usada) |

---

## 🔄 Fluxo de Trabalho de Deploy

### **1. Desenvolvimento Local**

```bash
# Fazer mudanças no código
vim app/Http/Controllers/SeuController.php

# Testar localmente
php artisan test

# Commitar
git add .
git commit -m "feat: Nova funcionalidade"

# Push para GitHub
git push origin main
```

### **2. Deploy para Produção**

```bash
# SSH no servidor e executar script de atualização
ssh root@172.233.21.57 "cd /var/www/freefi && bash update-production.sh"
```

**O script faz automaticamente:**
1. ✅ Backup do .env
2. ✅ Fetch do GitHub
3. ✅ Mostra mudanças
4. ✅ Pede confirmação
5. ✅ Aplica pull
6. ✅ Limpa caches
7. ✅ Reinicia serviços

---

## 📁 Estrutura de Repositórios

### **Local (Desenvolvimento)**
```
/var/www/html/laravel/admin/freefi_admin/
├── .git/
├── app/
├── resources/
└── ...
```

### **GitHub (Remoto)**
```
https://github.com/freefi-com-br/freefiadm
├── main (branch principal)
└── CI Pipeline (testes em PRs)
```

### **Produção (172.233.21.57)**
```
/var/www/freefi/
├── .git/
├── app/
├── resources/
├── update-production.sh  ← Script de deploy
└── .env (não versionado)
```

---

## 🔐 Arquivos Protegidos (Não Versionados)

Configurados via `.gitignore`:

- `.env` - Configurações de produção
- `storage/app/public/midias/` - Uploads de imagens/vídeos
- `storage/app/public/logos/` - Logotipos
- `storage/logs/` - Logs da aplicação
- `vendor/` - Dependências PHP
- `node_modules/` - Dependências Node

---

## 📝 Comandos Rápidos

```bash
# Verificar status em produção
ssh root@172.233.21.57 "cd /var/www/freefi && git status"

# Ver últimos commits em produção
ssh root@172.233.21.57 "cd /var/www/freefi && git log --oneline -5"

# Verificar se há atualizações disponíveis
ssh root@172.233.21.57 "cd /var/www/freefi && git fetch && git log HEAD..origin/main"

# Atualizar produção
ssh root@172.233.21.57 "cd /var/www/freefi && bash update-production.sh"

# Ver logs dos containers
ssh root@172.233.21.57 "cd /var/www/freefi && docker compose logs -f app"
```

---

## 🛠️ Troubleshooting

### **Atualização não aparece em produção**

```bash
# 1. Verificar se código chegou no GitHub
git log --oneline -3

# 2. Verificar status em produção
ssh root@172.233.21.57 "cd /var/www/freefi && git status"

# 3. Forçar pull
ssh root@172.233.21.57 "cd /var/www/freefi && git pull origin main"
```

### **Erro no script de atualização**

```bash
# Ver logs do Laravel
ssh root@172.233.21.57 "cd /var/www/freefi && docker compose logs --tail=50 app"

# Limpar caches manualmente
ssh root@172.233.21.57 "cd /var/www/freefi && docker compose exec app php artisan optimize:clear"
```

---

## 📞 Informações de Produção

**Servidor:** 172.233.21.57  
**Aplicação:** http://172.233.21.57:8082  
**PhpMyAdmin:** http://172.233.21.57:8083  
**Diretório:** /var/www/freefi  

**Credenciais:** Ver `CREDENCIAIS-PRODUCAO.md`

---

## 🔄 Se Precisar Reativar Deploy Automático

Para reativar a pipeline de deploy automático:

```bash
# 1. Renomear arquivo
mv .github/workflows/deploy.yml.disabled .github/workflows/deploy.yml

# 2. Simplificar para usar nosso script
# (editar deploy.yml conforme necessário)

# 3. Configurar secrets no GitHub:
# - SSH_HOST
# - SSH_USERNAME  
# - SSH_PRIVATE_KEY
# - SSH_PORT
```

---

**Última atualização:** 21/10/2025  
**Versão:** 1.0
