# Modelo Visual Padrão de Modais

> **Objetivo:** garantir consistência visual e comportamental em todos os modais da aplicação FreeFi Admin.

## Cores e Tipografia
- **Cabeçalho (`.modal-header`)**
  - Fundo: `#F7F3EC`
  - Texto/ícones: `#1E335C`
  - Borda inferior: remover (`border-bottom: none`)
  - Botão fechar (`.btn-close`): usar `--bs-btn-close-color: #1E335C`
- **Rodapé (`.modal-footer`)**
  - Fundo: `#F7F3EC`
  - Borda superior: remover (`border-top: none`)
  - Botão primário: fundo e borda `#1E335C`
  - Botão secundário/outline: texto e borda `#1E335C`

## Comportamento
- **Backdrop:** `data-bs-backdrop="static"` para evitar fechamento acidental ao clicar fora.
- **Tecla ESC:** desabilitar com `data-bs-keyboard="false"`, exceto quando o modal exigir fechamento rápido.
- **Fechamento:** manter apenas o botão `X` no header, salvo necessidade do fluxo.

## Estrutura Recomendada
```html
<div class="modal fade"
     id="exemploModal"
     tabindex="-1"
     aria-labelledby="exemploModalLabel"
     aria-hidden="true"
     data-bs-backdrop="static"
     data-bs-keyboard="false">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title d-flex align-items-center gap-2" id="exemploModalLabel">
          <i class="ph-duotone ph-circle-wavy-check"></i>
          <span>Título do Modal</span>
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>

      <div class="modal-body">
        <!-- Conteúdo -->
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-primary">Confirmar</button>
      </div>
    </div>
  </div>
</div>
```

## CSS Global
As regras acima já estão aplicadas em `resources/views/layouts/master.blade.php`. Para casos específicos onde outro visual seja necessário, adicione a classe `modal-theme-default-disabled` ao `modal-header`/`modal-footer` e aplique o estilo desejado manualmente.

## Checklist Antes de Criar um Modal
- [ ] Cabeçalho usa `h5.modal-title` com ícone opcional (`ph-duotone`).
- [ ] Fechamento via backdrop/ESC está desabilitado se o fluxo exigir confirmação.
- [ ] Footer segue os botões padrão (`primary` e `outline-secondary`) com coloração consistente.
- [ ] Conteúdo do body respeita espaçamento (`p-4` ou similar) e componentes de formulário seguem padrões existentes.
- [ ] Para modais grandes, considerar `modal-dialog-centered` e breakpoints (`modal-lg`, `modal-fullscreen-md-down`).

---

**Referência de implementação:** modal de analytics em `resources/views/publicacoes/index.blade.php`. ajustes globais aplicados em `resources/views/layouts/master.blade.php`.
