<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\HotspotCustomization;

class CustomizationController extends Controller
{
    /**
     * Retorna APENAS o script JavaScript (para injetar direto no HTML)
     * URL: /api/customization/{serial}/script.js
     */
    public function script(string $serial)
    {
        $customization = HotspotCustomization::activeBySerial($serial)->first();

        if (!$customization) {
            return response('// Nenhuma customização ativa', 200)
                ->header('Content-Type', 'application/javascript')
                ->header('Cache-Control', 'no-cache, no-store, must-revalidate');
        }

        return response($customization->generateLoaderScript(), 200)
            ->header('Content-Type', 'application/javascript')
            ->header('Cache-Control', 'no-cache, no-store, must-revalidate');
    }

    /**
     * Retorna a customização completa em JSON
     * URL: /api/customization/{serial}
     */
    public function show(string $serial)
    {
        $customization = HotspotCustomization::activeBySerial($serial)->first();

        if (!$customization) {
            return response()->json([
                'success' => false,
                'message' => 'Nenhuma customização encontrada',
                'use_default' => true
            ], 404);
        }

        return response()->json([
            'success' => true,
            'customization' => $customization->toArray()
        ]);
    }
}
