<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class NovoCadastroPendente extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
    public function __construct(
        public User $user
    ) {
        //
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: '🔔 Novo Cadastro Pendente de Aprovação - FreeFi Admin',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.novo-cadastro-pendente',
            with: [
                'userName' => $this->user->name,
                'userEmail' => $this->user->email,
                'empresaNome' => $this->user->empresa->name ?? 'N/A',
                'empresaTipo' => $this->user->empresa->tipo_empresa ?? 'N/A',
                'telefone' => $this->user->phone ?? 'N/A',
                'dataCadastro' => $this->user->created_at->format('d/m/Y H:i'),
                'usersUrl' => route('users.index'),
            ]
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
