<?php

namespace App\Models;

use App\Traits\Userstamps;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class WalledGarden extends Model
{
    /** @use HasFactory<\Database\Factories\WalledGardenFactory> */
    use HasFactory, SoftDeletes, Userstamps;

    /**
     * Nome da tabela
     */
    protected $table = 'walled_gardens';

    /**
     * Campos que podem ser preenchidos em massa
     */
    protected $fillable = [
        'publicacao_id',
        'tipo',
        'endereco',
        'descricao',
        'ativo',
    ];

    /**
     * Casting de atributos
     */
    protected $casts = [
        'ativo' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    /**
     * Valores padrão
     */
    protected $attributes = [
        'ativo' => true,
    ];

    /**
     * Relacionamento: Walled Garden pertence a uma Publicação
     */
    public function publicacao(): BelongsTo
    {
        return $this->belongsTo(Publicacao::class);
    }

    /**
     * Scopes para consultas comuns
     */
    public function scopeAtivos($query)
    {
        return $query->where('ativo', true);
    }

    public function scopePorTipo($query, string $tipo)
    {
        return $query->where('tipo', $tipo);
    }

    public function scopeDomains($query)
    {
        return $query->where('tipo', 'domain');
    }

    public function scopeIps($query)
    {
        return $query->where('tipo', 'ip');
    }

    public function scopeSubnets($query)
    {
        return $query->where('tipo', 'subnet');
    }
}
