<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Feature Flags - Sistema de Emails
    |--------------------------------------------------------------------------
    |
    | Controle granular sobre o envio de emails no sistema.
    | Útil para desenvolvimento, testes, manutenção e troubleshooting.
    |
    */

    // Flag mestre - desabilita TODOS os emails de uma vez
    'email_enabled' => env('FEATURE_EMAIL_ENABLED', true),

    // Controle individual por tipo de email
    'emails' => [
        // Email enviado quando um cadastro é aprovado
        'cadastro_aprovado' => env('FEATURE_EMAIL_CADASTRO_APROVADO', true),
        
        // Email enviado quando um cadastro é rejeitado
        'cadastro_rejeitado' => env('FEATURE_EMAIL_CADASTRO_REJEITADO', true),
        
        // Email enviado para admins quando há novo cadastro pendente
        'novo_cadastro_pendente' => env('FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Modo de Desenvolvimento
    |--------------------------------------------------------------------------
    |
    | Quando ativado, emails são logados mas não enviados.
    | Útil para desenvolvimento sem consumir quota de SMTP.
    |
    */
    'dev_mode' => env('FEATURE_EMAIL_DEV_MODE', false),

    /*
    |--------------------------------------------------------------------------
    | Email de Teste (Desenvolvimento)
    |--------------------------------------------------------------------------
    |
    | Quando definido, TODOS os emails serão redirecionados para este endereço.
    | Útil para testar sem enviar para usuários reais.
    |
    */
    'test_recipient' => env('FEATURE_EMAIL_TEST_RECIPIENT', null),

    /*
    |--------------------------------------------------------------------------
    | Feature Flags - Publicações
    |--------------------------------------------------------------------------
    |
    | Controle granular sobre funcionalidades do módulo de publicações.
    |
    */
    'publicacoes_permitir_data_passada' => env('FEATURE_PUBLICACOES_PERMITIR_DATA_PASSADA', true),

];