<?php

namespace Database\Factories;

use App\Models\Empresa;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Hotspot>
 */
class HotspotFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $marcas = ['Mikrotik', 'Ubiquiti', 'TP-Link', 'Cisco', 'Intelbras', 'D-Link'];
        $marca = fake()->randomElement($marcas);
        
        $modelos = [
            'Mikrotik' => ['hAP ac2', 'hAP ax2', 'RB750Gr3', 'RB4011'],
            'Ubiquiti' => ['UniFi AP AC Lite', 'UniFi AP AC Pro', 'UniFi 6 Lite', 'NanoStation'],
            'TP-Link' => ['Archer C6', 'Archer AX50', 'TL-WR940N', 'EAP225'],
            'Cisco' => ['WAP121', 'WAP321', 'AIR-AP1815I', 'CBW140AC'],
            'Intelbras' => ['AP 1200 AC Max', 'AP 360', 'Twibi Fast', 'W4-300F'],
            'D-Link' => ['DIR-615', 'DIR-842', 'DAP-1360', 'DWL-3200AP']
        ];
        
        return [
            'marca' => $marca,
            'modelo' => fake()->randomElement($modelos[$marca]),
            'serial' => strtoupper(fake()->bothify('??####??####')),
            'empresa_id' => Empresa::factory(),
            'status' => fake()->boolean(80) ? 0 : 1, // 80% ativo
            'last_activity_at' => fake()->boolean(60) ? fake()->dateTimeBetween('-7 days', 'now') : null, // 60% tem atividade recente
        ];
    }
}
