<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Publicacao>
 */
class PublicacaoFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'criativo_id' => \App\Models\Criativo::factory(),
            'franquia_id' => \App\Models\Empresa::factory(['tipo_empresa' => 'franquia']),
            'cliente_id' => \App\Models\Empresa::factory(['tipo_empresa' => 'cliente']),
            'titulo' => fake()->sentence(4),
            'data_inicio' => now()->subDays(10),
            'data_fim' => now()->addDays(20),
            'link_destino' => fake()->optional()->url(),
            'habilitar_clique' => fake()->boolean(70),
            'track_impressoes' => true,
            'track_cliques' => true,
            'valor_contrato' => fake()->randomFloat(2, 100, 10000),
            'impressoes_contratadas' => fake()->numberBetween(1000, 100000),
            'total_visualizacoes' => 0,
            'tipo_midia' => fake()->randomElement(['imagem', 'video']),
            'posicao' => fake()->numberBetween(1, 6),
            'status' => fake()->randomElement(['ativa', 'pausada', 'expirada', 'cancelada']),
            'tipo_alcance' => 'todos',
            'equipment_serial' => null,
            'empresa_alcance_id' => null,
            'publicada_por' => \App\Models\User::factory(),
            'publicada_em' => now(),
        ];
    }

    /**
     * Estado: Ativa
     */
    public function ativa(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'ativa',
            'data_inicio' => now()->subDays(5),
            'data_fim' => now()->addDays(25),
        ]);
    }

    /**
     * Estado: Vigente (ativa e no período)
     */
    public function vigente(): static
    {
        return $this->ativa();
    }

    /**
     * Estado: Com link clicável
     */
    public function comLink(): static
    {
        return $this->state(fn (array $attributes) => [
            'link_destino' => fake()->url(),
            'habilitar_clique' => true,
        ]);
    }

    /**
     * Estado: Serial específico
     */
    public function serialEspecifico(string $serial = null): static
    {
        return $this->state(fn (array $attributes) => [
            'tipo_alcance' => 'serial_especifico',
            'equipment_serial' => $serial ?? fake()->uuid(),
        ]);
    }

    /**
     * Estado: Empresa específica
     */
    public function empresaEspecifica(int $empresaId = null): static
    {
        return $this->state(fn (array $attributes) => [
            'tipo_alcance' => 'empresa',
            'empresa_alcance_id' => $empresaId ?? \App\Models\Empresa::factory(),
        ]);
    }
}
